/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.chrome;

import com.jpexs.browsers.cache.chrome.CacheAddr;
import com.jpexs.browsers.cache.chrome.IndexInputStream;
import com.jpexs.browsers.cache.chrome.LruData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Map;

public class IndexHeader {
    long magic;
    long version;
    int num_entries;
    int num_bytes;
    int last_file;
    int this_id;
    CacheAddr stats;
    int table_len;
    int crash;
    int experiment;
    long create_time;
    int[] pad = new int[52];
    LruData lru;

    public IndexHeader(InputStream is, File rootDir, Map<Integer, RandomAccessFile> dataFiles, File externalFilesDir) throws IOException {
        IndexInputStream iis = new IndexInputStream(is);
        this.magic = iis.readUInt32();
        this.version = iis.readUInt32();
        this.num_entries = iis.readInt32();
        this.num_bytes = iis.readInt32();
        this.last_file = iis.readInt32();
        this.this_id = iis.readInt32();
        this.stats = new CacheAddr(iis, rootDir, dataFiles, externalFilesDir);
        this.table_len = iis.readInt32();
        this.crash = iis.readInt32();
        this.experiment = iis.readInt32();
        this.create_time = iis.readUInt64();
        this.pad = new int[52];
        for (int i = 0; i < 52; ++i) {
            this.pad[i] = iis.readInt32();
        }
        this.lru = new LruData(is, rootDir, dataFiles, externalFilesDir);
    }
}

