/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.chrome;

import com.jpexs.browsers.cache.CacheEntry;
import com.jpexs.browsers.cache.chrome.CacheAddr;
import com.jpexs.browsers.cache.chrome.HttpResponseInfo;
import com.jpexs.browsers.cache.chrome.IndexInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EntryStore
extends CacheEntry {
    public static final int ENTRY_NORMAL = 0;
    public static final int ENTRY_EVICTED = 1;
    public static final int ENTRY_DOOMED = 2;
    public static final int PARENT_ENTRY = 1;
    public static final int CHILD_ENTRY = 2;
    public long hash;
    public CacheAddr next;
    public CacheAddr rankings_node;
    public int reuse_count;
    public int refetch_count;
    public int state;
    public long creation_time;
    public int key_len;
    public CacheAddr long_key;
    public int[] data_size = new int[4];
    public CacheAddr[] data_addr = new CacheAddr[4];
    public long flags;
    public int[] pad = new int[4];
    public long self_hash;
    public byte[] key = new byte[160];

    public EntryStore(InputStream is, File rootDir, Map<Integer, RandomAccessFile> dataFiles, File externalFilesDir) throws IOException {
        int i;
        IndexInputStream iis = new IndexInputStream(is);
        this.hash = iis.readUInt32();
        this.next = new CacheAddr(is, rootDir, dataFiles, externalFilesDir);
        this.rankings_node = new CacheAddr(is, rootDir, dataFiles, externalFilesDir);
        this.reuse_count = iis.readInt32();
        this.refetch_count = iis.readInt32();
        this.state = iis.readInt32();
        this.creation_time = iis.readUInt64();
        this.key_len = iis.readInt32();
        this.long_key = new CacheAddr(is, rootDir, dataFiles, externalFilesDir);
        this.data_size = new int[4];
        for (i = 0; i < 4; ++i) {
            this.data_size[i] = iis.readInt32();
        }
        this.data_addr = new CacheAddr[4];
        for (i = 0; i < 4; ++i) {
            this.data_addr[i] = new CacheAddr(is, rootDir, dataFiles, externalFilesDir);
        }
        this.flags = iis.readUInt32();
        this.pad = new int[4];
        for (i = 0; i < 4; ++i) {
            this.pad[i] = iis.readInt32();
        }
        this.self_hash = iis.readUInt32();
        this.key = new byte[160];
        if (iis.read(this.key) != this.key.length) {
            throw new IOException();
        }
    }

    public HttpResponseInfo getResponseInfo() {
        try {
            InputStream is = this.data_addr[0].getInputStream();
            if (is == null) {
                return null;
            }
            return new HttpResponseInfo(is);
        }
        catch (IOException ex) {
            Logger.getLogger(EntryStore.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public int getResponseDataSize() {
        return this.data_size[1];
    }

    @Override
    public InputStream getResponseRawDataStream() {
        try {
            return this.data_addr[1].getInputStream();
        }
        catch (IOException ex) {
            Logger.getLogger(EntryStore.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getKey() {
        if (this.key_len < 0) {
            return null;
        }
        return new String(this.key, 0, this.key_len > this.key.length ? this.key.length : this.key_len);
    }

    @Override
    public String getRequestURL() {
        return this.getKey();
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        HttpResponseInfo ri = this.getResponseInfo();
        if (ri == null) {
            return new HashMap<String, String>();
        }
        List<String> headers = ri.headers;
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int h = 1; h < headers.size(); ++h) {
            String hs = headers.get(h);
            if (!hs.contains(":")) continue;
            String[] hp = hs.split(":");
            ret.put(hp[0].trim(), hp[1].trim());
        }
        return ret;
    }

    @Override
    public String getStatusLine() {
        HttpResponseInfo ri = this.getResponseInfo();
        return ri.headers.get(0);
    }

    @Override
    public String getRequestMethod() {
        return "GET";
    }
}

