/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.chrome;

import com.jpexs.browsers.cache.CacheEntry;
import com.jpexs.browsers.cache.CacheImplementation;
import com.jpexs.browsers.cache.chrome.EntryStore;
import com.jpexs.browsers.cache.chrome.Index;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChromeCache
implements CacheImplementation {
    private static volatile ChromeCache instance;
    private File tempDir;
    private List<File> dataFiles;
    private File indexFile;
    private boolean loaded = false;
    private Index index;

    private ChromeCache() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ChromeCache.this.free();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChromeCache getInstance() {
        if (instance != null) return instance;
        Class<ChromeCache> clazz = ChromeCache.class;
        synchronized (ChromeCache.class) {
            if (instance != null) return instance;
            instance = new ChromeCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public List<CacheEntry> getEntries() {
        if (!this.loaded) {
            this.refresh();
        }
        if (!this.loaded) {
            return null;
        }
        ArrayList<CacheEntry> ret = new ArrayList<CacheEntry>();
        try {
            List<EntryStore> entries = this.index.getEntries();
            for (EntryStore en : entries) {
                String key;
                if (en.state != 0 || (key = en.getKey()) == null || key.trim().isEmpty()) continue;
                ret.add(en);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ChromeCache.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        return ret;
    }

    @Override
    public void refresh() {
        File originalDataFile;
        this.free();
        File cacheDir = null;
        try {
            cacheDir = ChromeCache.getCacheDirectory();
        }
        catch (IOException ex) {
            Logger.getLogger(ChromeCache.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (cacheDir == null) {
            return;
        }
        File systemTempDir = new File(System.getProperty("java.io.tmpdir"));
        File originalIndexFile = new File(cacheDir + File.separator + "index");
        this.tempDir = new File(systemTempDir, "cacheView" + System.identityHashCode(this));
        this.tempDir.deleteOnExit();
        this.tempDir.mkdir();
        this.indexFile = new File(this.tempDir, "index");
        this.indexFile.deleteOnExit();
        try {
            Files.copy(originalIndexFile.toPath(), this.indexFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            Logger.getLogger(ChromeCache.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        this.dataFiles = new ArrayList<File>();
        int i = 0;
        while ((originalDataFile = new File(cacheDir, "data_" + i)).exists()) {
            File dataFile = new File(this.tempDir, "data_" + i);
            dataFile.deleteOnExit();
            this.dataFiles.add(dataFile);
            try {
                Files.copy(originalDataFile.toPath(), dataFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                Logger.getLogger(ChromeCache.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            ++i;
        }
        try {
            this.index = new Index(this.indexFile, cacheDir);
        }
        catch (IOException ex) {
            Logger.getLogger(ChromeCache.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.loaded = true;
    }

    private static OSId getOSId() {
        PrivilegedAction<String> doGetOSName = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        };
        OSId id = OSId.UNIX;
        String osName = AccessController.doPrivileged(doGetOSName);
        if (osName != null) {
            if (osName.toLowerCase().startsWith("mac os x")) {
                id = OSId.OSX;
            } else if (osName.contains("Windows")) {
                id = OSId.WINDOWS;
            }
        }
        return id;
    }

    public static File getCacheDirectory() throws IOException {
        String userHome = null;
        File ret = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (userHome != null) {
            OSId osId = ChromeCache.getOSId();
            if (osId == OSId.WINDOWS) {
                ret = new File(userHome + "\\AppData\\Local\\Google\\Chrome\\User Data\\Default\\Cache\\");
                if (!ret.exists()) {
                    ret = new File(userHome + "\\Local Settings\\Application Data\\Google\\Chrome\\User Data\\Default\\Cache");
                }
            } else if (osId == OSId.OSX) {
                ret = new File(userHome + "/Library/Caches/Google/Chrome/Default/Cache");
            } else {
                ret = new File(userHome + "/.config/google-chrome/Default/Application Cache/Cache/");
                if (!ret.exists()) {
                    ret = new File(userHome + "/.cache/chromium/Default/Cache");
                }
            }
        }
        if (ret != null && !ret.exists()) {
            return null;
        }
        return ret;
    }

    private void free() {
        if (this.loaded) {
            this.index.free();
            this.indexFile.delete();
            for (File d : this.dataFiles) {
                d.delete();
            }
            this.tempDir.delete();
        }
    }

    private static enum OSId {
        WINDOWS,
        OSX,
        UNIX;

    }
}

