/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final InputStream is;
    private int chunkPos = 0;
    private int chunkLen = 0;
    private boolean end = false;
    private boolean first = true;

    public ChunkedInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        if (this.end) {
            return -1;
        }
        if (this.chunkPos >= this.chunkLen) {
            if (!this.first) {
                if (this.is.read() != 13) {
                    throw new IOException("Invalid chunk");
                }
                if (this.is.read() != 10) {
                    throw new IOException("Invalid chunk");
                }
            }
            String lenStr = this.readLine();
            try {
                this.chunkLen = Integer.parseInt(lenStr);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("Invalid chunk");
            }
            if (this.chunkLen == 0) {
                this.is.read();
                this.is.read();
                this.end = true;
                return -1;
            }
            this.chunkPos = 0;
            this.first = false;
        }
        ++this.chunkPos;
        return this.is.read();
    }

    private String readLine() throws IOException {
        int i;
        boolean inr = false;
        StringBuilder ret = new StringBuilder();
        while ((i = this.is.read()) > -1) {
            if (inr) {
                inr = false;
                if (i == 10) break;
                ret.append("\r");
            }
            if (i == 13) {
                inr = true;
                continue;
            }
            ret.append((char)i);
        }
        if (inr) {
            ret.append("\r");
        }
        return ret.toString();
    }
}

