/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache;

import com.jpexs.browsers.cache.ChunkedInputStream;
import com.jpexs.helpers.LimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public abstract class CacheEntry {
    public abstract String getRequestURL();

    public abstract Map<String, String> getResponseHeaders();

    public abstract String getStatusLine();

    public abstract String getRequestMethod();

    public abstract InputStream getResponseRawDataStream();

    public InputStream getResponseDataStream() {
        String encoding;
        InputStream rawIs;
        String contentLengthStr = this.getHeader("Content-Length");
        int contentLength = -1;
        if (contentLengthStr != null) {
            try {
                contentLength = Integer.parseInt(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        InputStream is = rawIs = this.getResponseRawDataStream();
        if (contentLength > -1) {
            is = new LimitedInputStream(is, (long)contentLength);
        }
        if ((encoding = this.getHeader("Content-Encoding")) != null) {
            switch (encoding) {
                case "gzip": {
                    try {
                        is = new GZIPInputStream(is);
                    }
                    catch (IOException ex) {
                        is = null;
                    }
                    break;
                }
                case "deflate": {
                    is = new InflaterInputStream(is);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if ("chunked".equals(this.getHeader("Transfer-Encoding"))) {
            is = new ChunkedInputStream(is);
        }
        return is;
    }

    public String toString() {
        return this.getRequestURL();
    }

    public int getStatusCode() {
        String st = this.getStatusLine();
        if (st == null) {
            return 0;
        }
        String[] parts = st.split(" ");
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public String getHeader(String header) {
        Map<String, String> m = this.getResponseHeaders();
        if (m == null) {
            return null;
        }
        for (String k : m.keySet()) {
            if (!k.toLowerCase().equals(header.toLowerCase())) continue;
            return m.get(k);
        }
        return null;
    }
}

