/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.Searchable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamSearch
implements Searchable {
    private final MemoryInputStream is;

    public StreamSearch(InputStream is) throws IOException {
        this.is = new MemoryInputStream(Helper.readStream(is));
    }

    @Override
    public Map<Long, InputStream> search(byte[] ... data) {
        return this.search((ProgressListener)null, data);
    }

    @Override
    public Map<Long, InputStream> search(ProgressListener progListener, byte[] ... data) {
        HashMap<Long, InputStream> ret = new HashMap<Long, InputStream>();
        int maxFindLen = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].length <= maxFindLen) continue;
            maxFindLen = data[i].length;
        }
        try {
            this.is.seek(0L);
            byte[] buf = new byte[4096];
            Object last = null;
            int cnt = 0;
            long pos = 0L;
            while ((cnt = this.is.read(buf)) > 0) {
                for (int i = -maxFindLen + 1; i < cnt; ++i) {
                    for (byte[] onedata : data) {
                        boolean match = true;
                        for (int d = 0; d < onedata.length; ++d) {
                            byte b;
                            if (i + d < 0) {
                                if (last == null) continue;
                                b = last[(last).length + i + d];
                            } else {
                                if (i + d >= buf.length) continue;
                                b = buf[i + d];
                            }
                            if (b == onedata[d]) continue;
                            match = false;
                            break;
                        }
                        if (!match) continue;
                        MemoryInputStream fis = new MemoryInputStream(this.is.getAllRead(), (int)pos + i);
                        ret.put(pos + (long)i, fis);
                    }
                }
                pos += (long)cnt;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StreamSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ret;
    }
}

