/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.helpers.streams.SeekableInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReReadableInputStream
extends SeekableInputStream {
    InputStream is;
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    byte[] converted;
    long pos = 0L;
    int count = 0;

    public int getCount() {
        return this.count;
    }

    public byte[] getAllRead() {
        return this.baos.toByteArray();
    }

    public long getPos() {
        return this.pos;
    }

    public ReReadableInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > (long)this.count) {
            this.pos = this.count;
            this.skip(pos - (long)this.count);
        }
        this.pos = pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.seek(0L);
    }

    @Override
    public int read() throws IOException {
        if (this.pos < (long)this.count) {
            if (this.converted == null) {
                this.converted = this.baos.toByteArray();
            }
            int ret = this.converted[(int)this.pos] & 0xFF;
            ++this.pos;
            return ret;
        }
        int i = this.is.read();
        if (i > -1) {
            this.baos.write(i);
            ++this.count;
        }
        ++this.pos;
        this.converted = null;
        return i;
    }

    @Override
    public int available() throws IOException {
        return this.count + this.is.available() - (int)this.pos;
    }

    public long length() throws IOException {
        return this.count + this.is.available();
    }
}

