/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CancellableWorker<T>
implements RunnableFuture<T> {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    private static List<CancellableWorker> workers = Collections.synchronizedList(new ArrayList());
    private final FutureTask<T> future;

    public CancellableWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return CancellableWorker.this.doInBackground();
            }
        };
        this.future = new FutureTask<T>(callable){

            @Override
            protected void done() {
                CancellableWorker.this.workerDone();
            }
        };
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        workers.add(this);
        this.future.run();
    }

    protected void onStart() {
    }

    protected void done() {
    }

    public final void execute() {
        this.onStart();
        THREAD_POOL.execute(this);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        boolean r = this.future.cancel(mayInterruptIfRunning);
        if (r) {
            this.workerCancelled();
        }
        return r;
    }

    public void workerCancelled() {
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    private void workerDone() {
        workers.remove(this);
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(final Callable<T> c, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        CancellableWorker worker = new CancellableWorker<T>(){

            @Override
            protected T doInBackground() throws Exception {
                return c.call();
            }
        };
        try {
            worker.execute();
            T t = worker.get(timeout, timeUnit);
            return t;
        }
        finally {
            worker.cancel(true);
        }
    }

    public static void cancelBackgroundThreads() {
        List<CancellableWorker> oldWorkers = workers;
        workers = Collections.synchronizedList(new ArrayList());
        for (CancellableWorker worker : oldWorkers) {
            if (worker != null) {
                worker.cancel(true);
                continue;
            }
            Logger.getLogger(CancellableWorker.class.getName()).log(Level.SEVERE, "worker is null");
        }
    }
}

