/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.decompiler.flash.helpers.Freed;
import com.jpexs.helpers.FileHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class Cache<K, V>
implements Freed {
    private Map<K, V> cache;
    private static final List<WeakReference<Cache>> instances = new ArrayList<WeakReference<Cache>>();
    public static final int STORAGE_FILES = 1;
    public static final int STORAGE_MEMORY = 2;
    private final boolean weak;
    private final boolean memoryOnly;
    private final String name;
    private static int storageType;

    public static <K, V> Cache<K, V> getInstance(boolean weak, boolean memoryOnly, String name) {
        Cache<K, V> instance = new Cache<K, V>(weak, memoryOnly, name);
        instances.add(new WeakReference<Cache<K, V>>(instance));
        return instance;
    }

    public static void clearAll() {
        for (WeakReference<Cache> cw : instances) {
            Cache c = (Cache)cw.get();
            if (c == null) continue;
            c.clear();
            c.initCache();
        }
    }

    public static void setStorageType(int storageType) {
        if (storageType == Cache.storageType) {
            return;
        }
        switch (storageType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("storageType must be one of STORAGE_FILES or STORAGE_MEMORY");
            }
        }
        if (storageType != Cache.storageType) {
            Cache.clearAll();
        }
        Cache.storageType = storageType;
    }

    public static int getStorageType() {
        return storageType;
    }

    private void initCache() {
        int thisStorageType = storageType;
        if (this.memoryOnly) {
            thisStorageType = 2;
        }
        AbstractMap newCache = null;
        if (thisStorageType == 1) {
            try {
                newCache = new FileHashMap(File.createTempFile("ffdec_cache_" + this.name + "_", ".tmp"));
            }
            catch (IOException ex) {
                thisStorageType = 2;
            }
        }
        if (thisStorageType == 2) {
            newCache = this.weak ? new WeakHashMap() : new HashMap();
        }
        if (this.cache instanceof Freed) {
            ((Freed)((Object)this.cache)).free();
        }
        this.cache = newCache;
    }

    private Cache(boolean weak, boolean memoryOnly, String name) {
        this.weak = weak;
        this.name = name;
        this.memoryOnly = memoryOnly;
        this.initCache();
    }

    public synchronized boolean contains(K key) {
        return this.cache.containsKey(key);
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized void remove(K key) {
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
        }
    }

    public synchronized V get(K key) {
        return this.cache.get(key);
    }

    public synchronized void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public boolean isFreeing() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void free() {
        if (this.cache instanceof Freed) {
            ((Freed)((Object)this.cache)).free();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (WeakReference cw : instances) {
                    Cache c = (Cache)cw.get();
                    if (c == null) continue;
                    c.clear();
                    c.free();
                }
            }
        });
        storageType = 1;
    }
}

