/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.NotItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class IfItem
extends GraphTargetItem
implements Block {
    public GraphTargetItem expression;
    public List<GraphTargetItem> onTrue;
    public List<GraphTargetItem> onFalse;

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.expression)) {
            return false;
        }
        dependencies.add(this.expression);
        return this.expression.isCompileTime(dependencies);
    }

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.onTrue != null) {
            ret.add(this.onTrue);
        }
        if (this.onFalse != null) {
            ret.add(this.onFalse);
        }
        return ret;
    }

    public IfItem(GraphSourceItem src, GraphSourceItem lineStartIns, GraphTargetItem expression, List<GraphTargetItem> onTrue, List<GraphTargetItem> onFalse) {
        super(src, lineStartIns, 16);
        this.expression = expression;
        this.onTrue = onTrue;
        this.onFalse = onFalse;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        GraphTargetItem expr = this.expression;
        List<GraphTargetItem> ifBranch = this.onTrue;
        List<GraphTargetItem> elseBranch = this.onFalse;
        if (this.onTrue.isEmpty()) {
            if (this.onFalse.isEmpty()) {
                if (expr instanceof NotItem) {
                    expr = ((NotItem)expr).getOriginal();
                }
            } else {
                expr = expr.invert(null);
                ifBranch = this.onFalse;
                elseBranch = this.onTrue;
            }
        }
        writer.append("if");
        if (writer.getFormatting().spaceBeforeParenthesesIfParentheses) {
            writer.append(" ");
        }
        writer.append("(");
        expr.toStringBoolean(writer, localData);
        writer.append(")");
        this.appendBlock(expr, writer, localData, ifBranch);
        if (elseBranch.size() > 0) {
            boolean elseIf;
            boolean bl = elseIf = elseBranch.size() == 1 && elseBranch.get(0) instanceof IfItem;
            if (writer.getFormatting().beginBlockOnNewLine) {
                writer.newLine();
            } else {
                writer.append(" ");
            }
            writer.append("else");
            if (!elseIf) {
                this.appendBlock(expr, writer, localData, elseBranch);
            } else {
                writer.append(" ");
                elseBranch.get(0).toStringSemicoloned(writer, localData);
            }
        }
        return writer;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (GraphTargetItem ti : this.onTrue) {
            if (ti instanceof ContinueItem) {
                ret.add((ContinueItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        for (GraphTargetItem ti : this.onFalse) {
            if (ti instanceof ContinueItem) {
                ret.add((ContinueItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return generator.generate(localData, this);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }
}

