/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GraphPath
implements Serializable {
    private final List<Integer> keys = new ArrayList<Integer>();
    private final List<Integer> vals = new ArrayList<Integer>();
    public final String rootName;

    public GraphPath(String rootName, List<Integer> keys, List<Integer> vals) {
        this.rootName = rootName;
        this.keys.addAll(keys);
        this.vals.addAll(vals);
    }

    public GraphPath(List<Integer> keys, List<Integer> vals) {
        this.rootName = "";
        this.keys.addAll(keys);
        this.vals.addAll(vals);
    }

    public GraphPath() {
        this.rootName = "";
    }

    public boolean startsWith(GraphPath p) {
        if (p.length() > this.length()) {
            return false;
        }
        ArrayList<Integer> otherKeys = new ArrayList<Integer>(p.keys);
        ArrayList<Integer> otherVals = new ArrayList<Integer>(p.vals);
        for (int i = 0; i < p.length(); ++i) {
            if (!Objects.equals(this.keys.get(i), otherKeys.get(i))) {
                return false;
            }
            if (Objects.equals(this.vals.get(i), otherVals.get(i))) continue;
            return false;
        }
        return true;
    }

    public GraphPath parent(int len) {
        GraphPath par = new GraphPath(this.rootName);
        for (int i = 0; i < len; ++i) {
            par.keys.add(this.keys.get(i));
            par.vals.add(this.vals.get(i));
        }
        return par;
    }

    public GraphPath sub(int part, int codePos) {
        GraphPath next = new GraphPath(this.rootName, this.keys, this.vals);
        next.keys.add(codePos);
        next.vals.add(part);
        return next;
    }

    public GraphPath(String rootName) {
        this.rootName = rootName;
    }

    public int length() {
        return this.vals.size();
    }

    public int get(int index) {
        return this.vals.get(index);
    }

    public int getKey(int index) {
        return this.keys.get(index);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + GraphPath.arrHashCode(this.keys);
        hash = 23 * hash + GraphPath.arrHashCode(this.vals);
        hash = 23 * hash + Objects.hashCode(this.rootName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphPath other = (GraphPath)obj;
        if (this.rootName == null != (other.rootName == null)) {
            return false;
        }
        if (!Objects.equals(this.rootName, other.rootName)) {
            return false;
        }
        if (!GraphPath.arrMatch(this.keys, other.keys)) {
            return false;
        }
        return GraphPath.arrMatch(this.vals, other.vals);
    }

    private static int arrHashCode(List<Integer> arr) {
        if (arr == null || arr.isEmpty()) {
            return 0;
        }
        int hash = 5;
        for (Integer i : arr) {
            hash = 23 * hash + Objects.hashCode(i);
        }
        return hash;
    }

    private static boolean arrMatch(List<Integer> arr, List<Integer> arr2) {
        if (arr.size() != arr2.size()) {
            return false;
        }
        for (int i = 0; i < arr.size(); ++i) {
            if (Objects.equals(arr.get(i), arr2.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String ret = this.rootName;
        for (int i = 0; i < this.keys.size(); ++i) {
            ret = ret + "/" + this.keys.get(i) + ":" + this.vals.get(i);
        }
        return ret;
    }
}

