/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.helpers.Helper;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DottedChain
implements Serializable,
Comparable<DottedChain> {
    public static final String NO_SUFFIX = "";
    public static final DottedChain EMPTY = new DottedChain(true);
    public static final DottedChain TOPLEVEL = new DottedChain(new String[0], "");
    public static final DottedChain BOOLEAN = new DottedChain(new String[]{"Boolean"}, "");
    public static final DottedChain STRING = new DottedChain(new String[]{"String"}, "");
    public static final DottedChain ARRAY = new DottedChain(new String[]{"Array"}, "");
    public static final DottedChain NUMBER = new DottedChain(new String[]{"Number"}, "");
    public static final DottedChain OBJECT = new DottedChain(new String[]{"Object"}, "");
    public static final DottedChain INT = new DottedChain(new String[]{"int"}, "");
    public static final DottedChain UINT = new DottedChain(new String[]{"uint"}, "");
    public static final DottedChain UNDEFINED = new DottedChain(new String[]{"Undefined"}, "");
    public static final DottedChain XML = new DottedChain(new String[]{"XML"}, "");
    public static final DottedChain NULL = new DottedChain(new String[]{"null"}, "");
    public static final DottedChain FUNCTION = new DottedChain(new String[]{"Function"}, "");
    public static final DottedChain VOID = new DottedChain(new String[]{"void"}, "");
    public static final DottedChain NAMESPACE = new DottedChain(new String[]{"Namespace"}, "");
    public static final DottedChain ALL = new DottedChain(new String[]{"*"}, "");
    private final String[] parts;
    private final int length;
    private final int hash;
    private boolean isNull = false;
    private String namespaceSuffix = "";

    public String getNamespaceSuffix() {
        return this.namespaceSuffix;
    }

    public static final DottedChain parseWithSuffix(String name) {
        if (name == null) {
            return EMPTY;
        }
        if (name.isEmpty()) {
            return TOPLEVEL;
        }
        String nameNoSuffix = name;
        String namespaceSuffix = NO_SUFFIX;
        if (name.matches(".*#[0-9]+$")) {
            nameNoSuffix = name.substring(0, name.lastIndexOf("#"));
            namespaceSuffix = name.substring(name.lastIndexOf("#"));
        }
        return new DottedChain(nameNoSuffix.split("\\."), namespaceSuffix);
    }

    private DottedChain(boolean isNull) {
        this.isNull = isNull;
        this.parts = new String[0];
        this.length = 0;
        this.hash = 0;
    }

    public DottedChain(DottedChain src) {
        this(src.parts, src.namespaceSuffix);
        this.isNull = src.isNull;
    }

    public DottedChain(List<String> parts) {
        this.length = parts.size();
        this.parts = parts.toArray(new String[this.length]);
        this.hash = this.calcHash();
    }

    public DottedChain(String[] parts, String namespaceSuffix) {
        if (parts.length == 1 && parts[0].isEmpty()) {
            this.length = 0;
            this.parts = new String[0];
        } else {
            this.length = parts.length;
            this.parts = parts;
        }
        this.hash = this.calcHash();
        this.namespaceSuffix = namespaceSuffix;
    }

    private DottedChain(String[] parts, int length) {
        this.length = length;
        this.parts = parts;
        this.hash = this.calcHash();
    }

    public boolean isTopLevel() {
        return !this.isNull && this.length == 0;
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public int size() {
        return this.length;
    }

    public String get(int index) {
        if (index >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.parts[index];
    }

    public DottedChain subChain(int count) {
        if (count > this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new DottedChain(this.parts, count);
    }

    public String getLast() {
        if (this.isNull) {
            return null;
        }
        if (this.length == 0) {
            return NO_SUFFIX;
        }
        return this.parts[this.length - 1];
    }

    public DottedChain getWithoutLast() {
        if (this.isNull) {
            return null;
        }
        if (this.length < 2) {
            return EMPTY;
        }
        return new DottedChain(this.parts, this.length - 1);
    }

    public DottedChain addWithSuffix(String name) {
        String addedNameNoSuffix = name;
        String addedNamespaceSuffix = NO_SUFFIX;
        if (name != null && name.matches(".*#[0-9]+$")) {
            addedNameNoSuffix = name.substring(0, name.lastIndexOf("#"));
            addedNamespaceSuffix = name.substring(name.lastIndexOf("#"));
        }
        return this.add(addedNameNoSuffix, addedNamespaceSuffix);
    }

    public DottedChain add(String name, String namespaceSuffix) {
        if (name == null) {
            return new DottedChain(this);
        }
        String[] nparts = new String[this.length + 1];
        if (this.length > 0) {
            System.arraycopy(this.parts, 0, nparts, 0, this.length);
        }
        nparts[nparts.length - 1] = name;
        return new DottedChain(nparts, namespaceSuffix);
    }

    protected String toString(boolean as3, boolean raw, boolean withSuffix) {
        if (this.isNull) {
            return NO_SUFFIX;
        }
        if (this.length == 0) {
            return NO_SUFFIX;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            if (i > 0) {
                ret.append(".");
            }
            String part = this.parts[i];
            boolean lastStar = i == this.length - 1 && "*".equals(part);
            ret.append(raw || lastStar ? part : IdentifiersDeobfuscation.printIdentifier(as3, part, new String[0]));
        }
        if (withSuffix) {
            ret.append(this.namespaceSuffix);
        }
        return ret.toString();
    }

    public String toFilePath() {
        if (this.isNull) {
            return NO_SUFFIX;
        }
        if (this.length == 0) {
            return NO_SUFFIX;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            if (i > 0) {
                ret.append(File.separator);
            }
            ret.append(Helper.makeFileName(IdentifiersDeobfuscation.printIdentifier(true, this.parts[i], new String[0])));
        }
        return ret.toString();
    }

    public List<String> toList() {
        return new ArrayList<String>(Arrays.asList(this.parts));
    }

    public String toPrintableString(boolean as3) {
        return this.toString(as3, false, true);
    }

    public String toRawString() {
        return this.toString(false, true, true);
    }

    public String toString() {
        return this.toRawString();
    }

    public int hashCode() {
        return this.hash;
    }

    private int calcHash() {
        if (this.isNull) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.parts[i].hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DottedChain other = (DottedChain)obj;
        if (this.isNull && other.isNull) {
            return true;
        }
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            String s1 = this.parts[i];
            String s2 = other.parts[i];
            if (s1.equals(s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(DottedChain o) {
        return this.toRawString().compareTo(o.toRawString());
    }
}

