/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.sound;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.types.sound.SoundDecoder;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;

public class MP3Decoder
extends SoundDecoder {
    private final Decoder decoder = new Decoder();
    private final MyInputStream inputStream = new MyInputStream();
    private final Bitstream bitStream = new Bitstream((InputStream)this.inputStream);

    public MP3Decoder(SoundFormat soundFormat) {
        super(soundFormat);
    }

    @Override
    public void decode(SWFInputStream sis, OutputStream os) throws IOException {
        SampleBuffer buf;
        byte[] data = sis.readBytesEx(sis.available(), "soundStream");
        this.inputStream.add(data);
        while ((buf = this.readFrame(this.decoder, this.bitStream)) != null) {
            short[] audio = buf.getBuffer();
            byte[] d = new byte[buf.getBufferLength() * 2];
            for (int i = 0; i < buf.getBufferLength(); ++i) {
                short s = audio[i];
                d[i * 2] = (byte)(s & 0xFF);
                d[i * 2 + 1] = (byte)(s >> 8 & 0xFF);
            }
            os.write(d);
        }
    }

    private SampleBuffer readFrame(Decoder decoder, Bitstream bitstream) {
        try {
            Header h = bitstream.readFrame();
            if (h == null) {
                return null;
            }
            this.soundFormat.samplingRate = MP3Decoder.getSamplingRate(h);
            this.soundFormat.stereo = h.mode() != 3;
            try {
                SampleBuffer ret = (SampleBuffer)decoder.decodeFrame(h, bitstream);
                bitstream.closeFrame();
                return ret;
            }
            catch (DecoderException ex) {
                return null;
            }
        }
        catch (BitstreamException ex) {
            return null;
        }
    }

    private static int getSamplingRate(Header h) {
        switch (h.sample_frequency()) {
            case 2: {
                if (h.version() == 1) {
                    return 32000;
                }
                if (h.version() == 0) {
                    return 16000;
                }
                return 8000;
            }
            case 0: {
                if (h.version() == 1) {
                    return 44100;
                }
                if (h.version() == 0) {
                    return 22050;
                }
                return 11025;
            }
            case 1: {
                if (h.version() == 1) {
                    return 48000;
                }
                if (h.version() == 0) {
                    return 24000;
                }
                return 12000;
            }
        }
        return 0;
    }

    class MyInputStream
    extends InputStream {
        byte[] buf = new byte[4096];
        int pos = 0;
        int remaining = 0;

        MyInputStream() {
        }

        public void add(byte[] data) {
            byte[] oldBuf;
            if (data == null || data.length == 0) {
                return;
            }
            int remaining = this.remaining;
            int requiredSize = data.length + remaining;
            byte[] buf = oldBuf = this.buf;
            int pos = this.pos;
            if (requiredSize > buf.length) {
                int newSize;
                for (newSize = buf.length; requiredSize > newSize; newSize *= 2) {
                }
                this.buf = buf = new byte[newSize];
            }
            if (remaining > 0) {
                System.arraycopy(oldBuf, pos, buf, 0, remaining);
            }
            this.pos = 0;
            System.arraycopy(data, 0, buf, remaining, data.length);
            this.remaining = remaining + data.length;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining > 0) {
                int result = this.buf[this.pos] & 0xFF;
                --this.remaining;
                ++this.pos;
                return result;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if ((len = Math.min(len, this.remaining)) > 0) {
                System.arraycopy(this.buf, this.pos, b, off, len);
                this.remaining -= len;
                this.pos += len;
            }
            return len;
        }
    }
}

