/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.sound;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.types.sound.SoundDecoder;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import java.io.IOException;
import java.io.OutputStream;

public class AdpcmDecoder
extends SoundDecoder {
    private static final int[] indexAdjustTable2bit = new int[]{-1, 2, -1, 2};
    private static final int[] indexAdjustTable3bit = new int[]{-1, -1, 2, 4, -1, -1, 2, 4};
    private static final int[] indexAdjustTable4bit = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    private static final int[] indexAdjustTable5bit = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 4, 6, 8, 10, 13, 16, -1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 4, 6, 8, 10, 13, 16};
    private static final int[] stepSizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};

    public AdpcmDecoder(SoundFormat soundFormat) {
        super(soundFormat);
    }

    private static int decode2bit(int deltaCode, AdpcmState state) {
        assert (deltaCode == (deltaCode & 3));
        int step = stepSizeTable[state.index];
        int difference = step >> 1;
        if ((deltaCode & 1) == 1) {
            difference += step;
        }
        if ((deltaCode & 2) == 2) {
            difference = -difference;
        }
        state.sample += difference;
        if (state.sample > Short.MAX_VALUE) {
            state.sample = Short.MAX_VALUE;
        } else if (state.sample < Short.MIN_VALUE) {
            state.sample = Short.MIN_VALUE;
        }
        state.index += indexAdjustTable2bit[deltaCode];
        if (state.index < 0) {
            state.index = 0;
        } else if (state.index > 88) {
            state.index = 88;
        }
        return state.sample;
    }

    private static int decode3bit(int deltaCode, AdpcmState state) {
        assert (deltaCode == (deltaCode & 7));
        int step = stepSizeTable[state.index];
        int difference = step >> 2;
        if ((deltaCode & 1) == 1) {
            difference += step >> 1;
        }
        if ((deltaCode & 2) == 2) {
            difference += step;
        }
        if ((deltaCode & 4) == 4) {
            difference = -difference;
        }
        state.sample += difference;
        if (state.sample > Short.MAX_VALUE) {
            state.sample = Short.MAX_VALUE;
        } else if (state.sample < Short.MIN_VALUE) {
            state.sample = Short.MIN_VALUE;
        }
        state.index += indexAdjustTable3bit[deltaCode];
        if (state.index < 0) {
            state.index = 0;
        } else if (state.index > 88) {
            state.index = 88;
        }
        return state.sample;
    }

    private static int decode4bit(int deltaCode, AdpcmState state) {
        assert (deltaCode == (deltaCode & 0xF));
        int step = stepSizeTable[state.index];
        int difference = step >> 3;
        if ((deltaCode & 1) == 1) {
            difference += step >> 2;
        }
        if ((deltaCode & 2) == 2) {
            difference += step >> 1;
        }
        if ((deltaCode & 4) == 4) {
            difference += step;
        }
        if ((deltaCode & 8) == 8) {
            difference = -difference;
        }
        state.sample += difference;
        if (state.sample > Short.MAX_VALUE) {
            state.sample = Short.MAX_VALUE;
        } else if (state.sample < Short.MIN_VALUE) {
            state.sample = Short.MIN_VALUE;
        }
        state.index += indexAdjustTable4bit[deltaCode];
        if (state.index < 0) {
            state.index = 0;
        } else if (state.index > 88) {
            state.index = 88;
        }
        return state.sample;
    }

    private static int decode5bit(int deltaCode, AdpcmState state) {
        assert (deltaCode >= 0);
        assert (deltaCode <= 31);
        int step = stepSizeTable[state.index];
        int difference = step >> 4;
        if ((deltaCode & 1) == 1) {
            difference += step >> 3;
        }
        if ((deltaCode & 2) == 2) {
            difference += step >> 2;
        }
        if ((deltaCode & 4) == 4) {
            difference += step >> 1;
        }
        if ((deltaCode & 8) == 8) {
            difference += step;
        }
        if ((deltaCode & 0x10) == 16) {
            difference = -difference;
        }
        state.sample += difference;
        if (state.sample > Short.MAX_VALUE) {
            state.sample = Short.MAX_VALUE;
        } else if (state.sample < Short.MIN_VALUE) {
            state.sample = Short.MIN_VALUE;
        }
        state.index += indexAdjustTable5bit[deltaCode];
        if (state.index < 0) {
            state.index = 0;
        } else if (state.index > 88) {
            state.index = 88;
        }
        return state.sample;
    }

    @Override
    public void decode(SWFInputStream sis, OutputStream os) throws IOException {
        SWFOutputStream sos = new SWFOutputStream(os, 10);
        int adpcm_code_size = (int)sis.readUB(2, "adpcm_code_size");
        int bits_per_code = adpcm_code_size + 2;
        try {
            do {
                if (this.soundFormat.stereo) {
                    int initialSampleLeft = (int)sis.readSB(16, "initialSampleLeft");
                    int initialIndexLeft = (int)sis.readUB(6, "initialIndexLeft");
                    int initialSampleRight = (int)sis.readSB(16, "initialSampleRight");
                    int initialIndexRight = (int)sis.readUB(6, "initialIndexRight");
                    AdpcmState stateLeft = new AdpcmState();
                    stateLeft.index = initialIndexLeft;
                    stateLeft.sample = initialSampleLeft;
                    AdpcmState stateRight = new AdpcmState();
                    stateRight.index = initialIndexRight;
                    stateRight.sample = initialSampleRight;
                    for (int i = 1; i <= 4095 && sis.availableBits() >= (long)(bits_per_code * 2); ++i) {
                        int codeLeft = (int)sis.readUB(bits_per_code, "codeLeft");
                        int codeRight = (int)sis.readUB(bits_per_code, "codeRight");
                        int valLeft = 0;
                        int valRight = 0;
                        switch (bits_per_code) {
                            case 2: {
                                valLeft = AdpcmDecoder.decode2bit(codeLeft, stateLeft);
                                valRight = AdpcmDecoder.decode2bit(codeRight, stateRight);
                                break;
                            }
                            case 3: {
                                valLeft = AdpcmDecoder.decode3bit(codeLeft, stateLeft);
                                valRight = AdpcmDecoder.decode3bit(codeRight, stateRight);
                                break;
                            }
                            case 4: {
                                valLeft = AdpcmDecoder.decode4bit(codeLeft, stateLeft);
                                valRight = AdpcmDecoder.decode4bit(codeRight, stateRight);
                                break;
                            }
                            case 5: {
                                valLeft = AdpcmDecoder.decode5bit(codeLeft, stateLeft);
                                valRight = AdpcmDecoder.decode5bit(codeRight, stateRight);
                            }
                        }
                        sos.writeSI16(valLeft);
                        sos.writeSI16(valRight);
                    }
                } else {
                    int initialSample = (int)sis.readSB(16, "initialSample");
                    int initialIndex = (int)sis.readUB(6, "initialIndex");
                    AdpcmState state = new AdpcmState();
                    state.index = initialIndex;
                    state.sample = initialSample;
                    for (int i = 1; i <= 4095 && sis.availableBits() >= (long)bits_per_code; ++i) {
                        int code = (int)sis.readUB(bits_per_code, "code");
                        int val = 0;
                        switch (bits_per_code) {
                            case 2: {
                                val = AdpcmDecoder.decode2bit(code, state);
                                break;
                            }
                            case 3: {
                                val = AdpcmDecoder.decode3bit(code, state);
                                break;
                            }
                            case 4: {
                                val = AdpcmDecoder.decode4bit(code, state);
                                break;
                            }
                            case 5: {
                                val = AdpcmDecoder.decode5bit(code, state);
                            }
                        }
                        sos.writeSI16(val);
                    }
                }
            } while (sis.available() > 0);
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
    }

    private static class AdpcmState {
        public int index;
        public int sample;

        private AdpcmState() {
        }
    }
}

