/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.shaperecords;

import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Calculated;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;

public class StraightEdgeRecord
extends SHAPERECORD {
    public static final boolean typeFlag = true;
    public static final boolean straightFlag = true;
    @Calculated
    @SWFType(value=BasicType.UB, count=4)
    public int numBits;
    public boolean generalLineFlag;
    @Conditional(value={"!generalLineFlag"})
    public boolean vertLineFlag;
    @SWFType(value=BasicType.SB, countField="numBits", countAdd=2)
    @Conditional(value={"generalLineFlag|!vertLineFlag"})
    public int deltaX;
    @SWFType(value=BasicType.SB, countField="numBits", countAdd=2)
    @Conditional(value={"generalLineFlag|vertLineFlag"})
    public int deltaY;

    public String toString() {
        return "[StraightEdgeRecord numBits=" + this.numBits + ", generalLineFlag=" + this.generalLineFlag + ", vertLineFlag=" + this.vertLineFlag + ", deltaX=" + this.deltaX + ", deltaY=" + this.deltaY + "]";
    }

    @Override
    public int changeX(int x) {
        if (this.generalLineFlag) {
            return x + this.deltaX;
        }
        if (this.vertLineFlag) {
            return x;
        }
        return x + this.deltaX;
    }

    @Override
    public int changeY(int y) {
        if (this.generalLineFlag) {
            return y + this.deltaY;
        }
        if (this.vertLineFlag) {
            return y + this.deltaY;
        }
        return y;
    }

    @Override
    public void flip() {
        this.deltaX = -this.deltaX;
        this.deltaY = -this.deltaY;
    }

    @Override
    public boolean isMove() {
        return true;
    }

    @Override
    public void calculateBits() {
        this.numBits = SWFOutputStream.getNeededBitsS(this.deltaX, this.deltaY) - 2;
        if (this.numBits < 0) {
            this.numBits = 0;
        }
    }

    public void simplify() {
        if (this.generalLineFlag) {
            if (this.deltaX == 0) {
                this.generalLineFlag = false;
                this.vertLineFlag = true;
            } else if (this.deltaY == 0) {
                this.generalLineFlag = false;
                this.vertLineFlag = false;
            }
        }
    }
}

