/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.gfx;

import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.gfx.ContourType;
import com.jpexs.decompiler.flash.types.gfx.GFxInputStream;
import com.jpexs.decompiler.flash.types.gfx.GFxOutputStream;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GlyphType
implements Serializable {
    public int[] boundingBox;
    public ContourType[] contours;

    public GlyphType(List<SHAPERECORD> records) {
        RECT bounds = SHAPERECORD.getBounds(records);
        this.boundingBox = new int[4];
        this.boundingBox[0] = bounds.Xmin;
        this.boundingBox[1] = bounds.Ymin;
        this.boundingBox[2] = bounds.Xmax;
        this.boundingBox[3] = bounds.Ymax;
        ArrayList<SHAPERECORD> cont = new ArrayList<SHAPERECORD>();
        ArrayList<ContourType> contoursList = new ArrayList<ContourType>();
        for (int i = 0; i < records.size(); ++i) {
            SHAPERECORD r = records.get(i);
            if (r instanceof StyleChangeRecord && ((StyleChangeRecord)r).stateMoveTo && !cont.isEmpty()) {
                contoursList.add(new ContourType(cont));
                cont.clear();
            }
            cont.add(r);
        }
        if (!cont.isEmpty()) {
            contoursList.add(new ContourType(cont));
            cont.clear();
        }
        this.contours = contoursList.toArray(new ContourType[contoursList.size()]);
    }

    public GlyphType(GFxInputStream sis, long fontOffset) throws IOException {
        this.boundingBox = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.boundingBox[i] = sis.readSI15("boundingBox");
        }
        int numContours = sis.readUI15("numContours");
        this.contours = new ContourType[numContours];
        for (int i = 0; i < numContours; ++i) {
            sis.newDumpLevel("contourType", "ContourType");
            this.contours[i] = new ContourType(sis, fontOffset);
            sis.endDumpLevel();
        }
    }

    public SHAPE toSHAPE() {
        SHAPE shp = new SHAPE();
        shp.numFillBits = 1;
        shp.numLineBits = 0;
        ArrayList<SHAPERECORD> recs = new ArrayList<SHAPERECORD>();
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.fillStyle0 = 0;
        scr.fillStyle1 = 1;
        scr.stateFillStyle1 = true;
        scr.stateFillStyle0 = false;
        recs.add(scr);
        for (ContourType cnt : this.contours) {
            recs.addAll(cnt.toSHAPERECORDS());
        }
        recs.add(new EndShapeRecord());
        shp.shapeRecords = recs;
        return shp;
    }

    public void write(GFxOutputStream sos) throws IOException {
        for (int b : this.boundingBox) {
            sos.writeSI15(b);
        }
        sos.writeUI15(this.contours.length);
        for (ContourType cnt : this.contours) {
            cnt.write(sos);
        }
    }
}

