/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.awt.Color;
import java.io.Serializable;

public class RGBA
extends RGB
implements Serializable {
    @SWFType(value=BasicType.UI8)
    public int alpha;

    public float getAlphaFloat() {
        return (float)this.alpha / 255.0f;
    }

    public String toHexARGB() {
        String bh;
        String gh;
        String rh;
        String ra = Integer.toHexString(this.alpha);
        if (ra.length() < 2) {
            ra = "0" + ra;
        }
        if ((rh = Integer.toHexString(this.red)).length() < 2) {
            rh = "0" + rh;
        }
        if ((gh = Integer.toHexString(this.green)).length() < 2) {
            gh = "0" + gh;
        }
        if ((bh = Integer.toHexString(this.blue)).length() < 2) {
            bh = "0" + bh;
        }
        return "#" + ra + rh + gh + bh;
    }

    public RGBA(int red, int green, int blue, int alpha) {
        super(red, green, blue);
        this.alpha = alpha;
    }

    public RGBA(Color color) {
        super(color);
        this.alpha = color.getAlpha();
    }

    public RGBA(int rgb) {
        super(rgb);
        this.alpha = rgb >> 24 & 0xFF;
    }

    public RGBA() {
    }

    @Override
    public Color toColor() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    @Override
    public int toInt() {
        return RGBA.toInt(this.red, this.green, this.blue, this.alpha);
    }

    public static int toInt(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    @Override
    public String toString() {
        if (Configuration.useHexColorFormat.get().booleanValue()) {
            return "[RGB " + this.toHexRGB() + "]";
        }
        return "[RGB red:" + this.red + ", green:" + this.green + ", blue:" + this.blue + ", alpha:" + this.alpha + "]";
    }
}

