/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AS3Package
extends AS3ClassTreeItem {
    private final SWF swf;
    public String packageName;
    private final Map<String, AS3Package> subPackages = new TreeMap<String, AS3Package>();
    private final Map<String, ScriptPack> scripts = new TreeMap<String, ScriptPack>();
    private List<AS3Package> sortedPackages;
    private List<ScriptPack> sortedScripts;

    public AS3Package(String packageName, SWF swf) {
        super(packageName, "", null);
        this.swf = swf;
        this.packageName = packageName;
    }

    @Override
    public SWF getSwf() {
        return this.swf;
    }

    public List<AS3Package> getSubPackages() {
        if (this.sortedPackages == null) {
            ArrayList<AS3Package> list = new ArrayList<AS3Package>();
            for (AS3Package subPackage : this.subPackages.values()) {
                list.add(subPackage);
            }
            this.sortedPackages = list;
        }
        return this.sortedPackages;
    }

    public List<ScriptPack> getScriptPacks() {
        if (this.sortedScripts == null) {
            ArrayList<ScriptPack> list = new ArrayList<ScriptPack>();
            for (ScriptPack script : this.scripts.values()) {
                list.add(script);
            }
            this.sortedScripts = list;
        }
        return this.sortedScripts;
    }

    public void addScriptPack(ScriptPack script) {
        ClassPath cp = script.getClassPath();
        this.scripts.put(cp.className + cp.namespaceSuffix, script);
        this.sortedScripts = null;
    }

    public void addSubPackage(AS3Package subPackage) {
        this.subPackages.put(subPackage.getNameWithNamespaceSuffix(), subPackage);
        this.sortedPackages = null;
    }

    public AS3Package getSubPackage(String packageName) {
        return this.subPackages.get(packageName);
    }

    public List<AS3ClassTreeItem> getAllChildren() {
        ArrayList<AS3ClassTreeItem> result = new ArrayList<AS3ClassTreeItem>(this.getChildCount());
        result.addAll(this.subPackages.values());
        result.addAll(this.scripts.values());
        return result;
    }

    public AS3ClassTreeItem getChild(int index) {
        if (index < this.subPackages.size()) {
            return this.getSubPackages().get(index);
        }
        return this.getScriptPacks().get(index -= this.subPackages.size());
    }

    public int getChildCount() {
        return this.subPackages.size() + this.scripts.size();
    }

    public int getIndexOfChild(AS3ClassTreeItem child) {
        int res = 0;
        if (child instanceof AS3Package) {
            for (AS3Package pkg : this.subPackages.values()) {
                if (pkg.packageName.equals(((AS3Package)child).packageName)) break;
                ++res;
            }
            return res;
        }
        res = this.subPackages.size();
        for (ScriptPack pack : this.scripts.values()) {
            if (pack.equals(child)) break;
            ++res;
        }
        return res;
    }

    public void clear() {
        this.subPackages.clear();
        this.scripts.clear();
        this.sortedPackages = null;
        this.sortedScripts = null;
    }

    @Override
    public String toString() {
        return IdentifiersDeobfuscation.printIdentifier(true, this.packageName, new String[0]);
    }

    @Override
    public boolean isModified() {
        List<ScriptPack> sps = this.getScriptPacks();
        for (ScriptPack sp : sps) {
            if (!sp.isModified()) continue;
            return true;
        }
        List<AS3Package> ps = this.getSubPackages();
        for (AS3Package p : ps) {
            if (!p.isModified()) continue;
            return true;
        }
        return false;
    }
}

