/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.FontHelper;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.gfx.FontType;
import com.jpexs.decompiler.flash.types.gfx.GFxInputStream;
import com.jpexs.decompiler.flash.types.gfx.GFxOutputStream;
import com.jpexs.decompiler.flash.types.gfx.GlyphInfoType;
import com.jpexs.decompiler.flash.types.gfx.GlyphType;
import com.jpexs.decompiler.flash.types.gfx.KerningPairType;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.MemoryInputStream;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DefineCompactedFont
extends FontTag {
    public static final int ID = 1005;
    public static final String NAME = "DefineCompactedFont";
    public int fontId;
    public List<FontType> fonts;
    private List<SHAPE> shapeCache;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.fontId);
        for (FontType ft : this.fonts) {
            ft.write(new GFxOutputStream(sos));
        }
    }

    public DefineCompactedFont(SWF swf) {
        super(swf, 1005, NAME, null);
        this.fontId = swf.getNextCharacterId();
        this.fonts = new ArrayList<FontType>();
        FontType ft = new FontType();
        this.fonts.add(ft);
        this.rebuildShapeCache();
    }

    public DefineCompactedFont(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1005, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.fontId = sis.readUI16("fontId");
        this.fonts = new ArrayList<FontType>();
        MemoryInputStream mis = sis.getBaseStream();
        while (mis.available() > 0) {
            GFxInputStream gis = new GFxInputStream(mis);
            gis.dumpInfo = sis.dumpInfo;
            gis.newDumpLevel("fontType", "FontType");
            this.fonts.add(new FontType(gis));
            gis.endDumpLevel();
        }
        sis.skipBytes(sis.available());
        if (this.fonts.size() > 1) {
            Logger.getLogger(DefineCompactedFont.class.getName()).log(Level.WARNING, "Compacted font has more than one FontType inside. This may cause problems while editing.");
        }
        this.rebuildShapeCache();
    }

    public void rebuildShapeCache() {
        this.shapeCache = this.fonts.get(0).getGlyphShapes();
    }

    @Override
    public String getFontNameIntag() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.fonts.size(); ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(this.fonts.get((int)i).fontName);
        }
        return ret.toString();
    }

    @Override
    public int getCharacterId() {
        return this.fontId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.fontId = characterId;
    }

    @Override
    public List<SHAPE> getGlyphShapeTable() {
        return this.shapeCache;
    }

    @Override
    public void addCharacter(char character, Font cfont) {
        int fontStyle = this.getFontStyle();
        FontType font = this.fonts.get(0);
        double d = 1.0;
        SHAPE shp = SHAPERECORD.fontCharacterToSHAPE(cfont, (int)((double)font.nominalSize * d), character);
        char code = character;
        int pos = -1;
        boolean exists = false;
        for (int i = 0; i < font.glyphInfo.size(); ++i) {
            if (font.glyphInfo.get((int)i).glyphCode < code) continue;
            if (font.glyphInfo.get((int)i).glyphCode == code) {
                exists = true;
            }
            pos = i;
            break;
        }
        if (pos == -1) {
            pos = font.glyphInfo.size();
        }
        if (!exists) {
            this.shiftGlyphIndices(this.fontId, pos, true);
        }
        Font fnt = cfont.deriveFont(fontStyle, Math.round((double)font.nominalSize * d));
        int advance = Math.round(FontHelper.getFontAdvance(fnt, character));
        if (!exists) {
            font.glyphInfo.add(pos, new GlyphInfoType(code, advance, 0));
            font.glyphs.add(pos, new GlyphType(shp.shapeRecords));
            this.shapeCache.add(pos, font.glyphs.get(pos).toSHAPE());
        } else {
            font.glyphInfo.set(pos, new GlyphInfoType(code, advance, 0));
            font.glyphs.set(pos, new GlyphType(shp.shapeRecords));
            this.shapeCache.set(pos, font.glyphs.get(pos).toSHAPE());
        }
        this.setModified(true);
        this.getSwf().clearImageCache();
    }

    @Override
    public boolean removeCharacter(char character) {
        FontType font = this.fonts.get(0);
        char code = character;
        int pos = -1;
        for (int i = 0; i < font.glyphInfo.size(); ++i) {
            if (font.glyphInfo.get((int)i).glyphCode < code) continue;
            if (font.glyphInfo.get((int)i).glyphCode == code) {
                pos = i;
                break;
            }
            return false;
        }
        if (pos == -1) {
            return false;
        }
        font.glyphInfo.remove(pos);
        font.glyphs.remove(pos);
        this.shapeCache.remove(pos);
        this.shiftGlyphIndices(this.fontId, pos + 1, false);
        this.setModified(true);
        this.getSwf().clearImageCache();
        return true;
    }

    @Override
    public void setAdvanceValues(Font font) {
        throw new UnsupportedOperationException("Setting the advance values for DefineCompactedFont is not supported.");
    }

    @Override
    public char glyphToChar(int glyphIndex) {
        return (char)this.fonts.get((int)0).glyphInfo.get((int)glyphIndex).glyphCode;
    }

    @Override
    public int charToGlyph(char c) {
        FontType ft = this.fonts.get(0);
        for (int i = 0; i < ft.glyphInfo.size(); ++i) {
            if (ft.glyphInfo.get((int)i).glyphCode != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double getGlyphAdvance(int glyphIndex) {
        return this.resize(this.fonts.get((int)0).glyphInfo.get((int)glyphIndex).advanceX);
    }

    @Override
    public int getGlyphKerningAdjustment(int glyphIndex, int nextGlyphIndex) {
        char c1 = this.glyphToChar(glyphIndex);
        char c2 = this.glyphToChar(nextGlyphIndex);
        return this.getCharKerningAdjustment(c1, c2);
    }

    @Override
    public int getCharKerningAdjustment(char c1, char c2) {
        for (KerningPairType kp : this.fonts.get((int)0).kerning) {
            if (kp.char1 != c1 || kp.char2 != c2) continue;
            return this.resize(kp.advance);
        }
        return 0;
    }

    @Override
    public int getGlyphWidth(int glyphIndex) {
        return this.resize(this.getGlyphShapeTable().get(glyphIndex).getBounds().getWidth());
    }

    @Override
    public boolean isSmall() {
        return false;
    }

    @Override
    public boolean isBold() {
        return (this.fonts.get((int)0).flags & 2) == 2;
    }

    @Override
    public boolean isItalic() {
        return (this.fonts.get((int)0).flags & 1) == 1;
    }

    @Override
    public boolean isSmallEditable() {
        return false;
    }

    @Override
    public boolean isBoldEditable() {
        return true;
    }

    @Override
    public boolean isItalicEditable() {
        return true;
    }

    @Override
    public void setSmall(boolean value) {
    }

    @Override
    public void setBold(boolean value) {
        for (FontType font : this.fonts) {
            font.flags &= 2;
            if (value) continue;
            font.flags ^= 2;
        }
    }

    @Override
    public void setItalic(boolean value) {
        for (FontType font : this.fonts) {
            font.flags &= 1;
            if (value) continue;
            font.flags ^= 1;
        }
    }

    @Override
    public double getDivider() {
        return 1.0;
    }

    @Override
    public int getAscent() {
        return this.fonts.get((int)0).ascent;
    }

    @Override
    public int getDescent() {
        return this.fonts.get((int)0).descent;
    }

    @Override
    public int getLeading() {
        return this.fonts.get((int)0).leading;
    }

    @Override
    public int getCharacterCount() {
        FontType ft = this.fonts.get(0);
        return ft.glyphInfo.size();
    }

    @Override
    public String getCharacters() {
        FontType ft = this.fonts.get(0);
        StringBuilder ret = new StringBuilder(ft.glyphInfo.size());
        for (GlyphInfoType gi : ft.glyphInfo) {
            ret.append((char)gi.glyphCode);
        }
        return ret.toString();
    }

    @Override
    public RECT getGlyphBounds(int glyphIndex) {
        GlyphType gt = this.fonts.get((int)0).glyphs.get(glyphIndex);
        return new RECT(this.resize(gt.boundingBox[0]), this.resize(gt.boundingBox[1]), this.resize(gt.boundingBox[2]), this.resize(gt.boundingBox[3]));
    }

    public SHAPE resizeShape(SHAPE shp) {
        SHAPE ret = new SHAPE();
        ret.numFillBits = 1;
        ret.numLineBits = 0;
        ArrayList<SHAPERECORD> recs = new ArrayList<SHAPERECORD>();
        for (SHAPERECORD r : shp.shapeRecords) {
            SHAPERECORD c = r.clone();
            if (c instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)c;
                scr.moveDeltaX = this.resize(scr.moveDeltaX);
                scr.moveDeltaY = this.resize(scr.moveDeltaY);
                scr.calculateBits();
            }
            if (c instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)c;
                cer.controlDeltaX = this.resize(cer.controlDeltaX);
                cer.controlDeltaY = this.resize(cer.controlDeltaY);
                cer.anchorDeltaX = this.resize(cer.anchorDeltaX);
                cer.anchorDeltaY = this.resize(cer.anchorDeltaY);
                cer.calculateBits();
            }
            if (c instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)c;
                ser.deltaX = this.resize(ser.deltaX);
                ser.deltaY = this.resize(ser.deltaY);
                ser.calculateBits();
            }
            recs.add(c);
        }
        ret.shapeRecords = recs;
        return ret;
    }

    protected int resize(double val) {
        FontType ft = this.fonts.get(0);
        return (int)Math.round(val * 1024.0 / (double)ft.nominalSize);
    }

    @Override
    public FontTag toClassicFont() {
        DefineFont2Tag ret = new DefineFont2Tag(this.swf);
        ret.fontID = this.getFontId();
        ret.fontFlagsBold = this.isBold();
        ret.fontFlagsItalic = this.isItalic();
        ret.fontFlagsWideOffsets = true;
        ret.fontFlagsWideCodes = true;
        ret.fontFlagsHasLayout = true;
        ret.fontAscent = this.resize(this.getAscent());
        ret.fontDescent = this.resize(this.getDescent());
        ret.fontLeading = this.resize(this.getLeading());
        ret.fontAdvanceTable = new ArrayList<Integer>();
        ret.fontBoundsTable = new ArrayList<RECT>();
        ret.codeTable = new ArrayList<Integer>();
        ret.glyphShapeTable = new ArrayList<SHAPE>();
        List<SHAPE> shp = this.getGlyphShapeTable();
        for (int g = 0; g < shp.size(); ++g) {
            ret.fontAdvanceTable.add((int)this.getGlyphAdvance(g));
            ret.codeTable.add(Integer.valueOf(this.glyphToChar(g)));
            SHAPE shpX = this.resizeShape(shp.get(g));
            ret.glyphShapeTable.add(shpX);
            ret.fontBoundsTable.add(this.getGlyphBounds(g));
        }
        ret.fontName = this.getFontNameIntag();
        ret.languageCode = new LANGCODE(1);
        ret.fontKerningTable = new ArrayList<KERNINGRECORD>();
        FontType ft = this.fonts.get(0);
        for (int i = 0; i < ft.kerning.size(); ++i) {
            KERNINGRECORD kr = new KERNINGRECORD();
            kr.fontKerningAdjustment = this.resize(ft.kerning.get((int)i).advance);
            kr.fontKerningCode1 = ft.kerning.get((int)i).char1;
            kr.fontKerningCode2 = ft.kerning.get((int)i).char2;
            ret.fontKerningTable.add(kr);
        }
        return ret;
    }

    @Override
    public boolean hasLayout() {
        return true;
    }
}

