/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;

@SWFVersion(from=8)
public class DefineScalingGridTag
extends Tag
implements CharacterIdTag {
    public static final int ID = 78;
    public static final String NAME = "DefineScalingGrid";
    @SWFType(value=BasicType.UI16)
    public int characterId;
    public RECT splitter;

    public DefineScalingGridTag(SWF swf) {
        super(swf, 78, NAME, null);
        this.splitter = new RECT();
    }

    public DefineScalingGridTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 78, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterId = sis.readUI16("characterId");
        this.splitter = sis.readRECT("splitter");
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterId);
        sos.writeRECT(this.splitter);
    }

    @Override
    public int getCharacterId() {
        return this.characterId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterId = characterId;
    }

    private static double roundPixels(double v) {
        return v;
    }

    private static double roundPixels20(double v) {
        return Math.rint(v / 20.0) * 20.0;
    }

    private static Matrix rectToRectMatrix(ExportRectangle fromRect, ExportRectangle toRect) {
        Matrix toOrigin = Matrix.getTranslateInstance(DefineScalingGridTag.roundPixels(-fromRect.xMin), DefineScalingGridTag.roundPixels(-fromRect.yMin));
        Matrix scale = new Matrix();
        scale.scaleX = DefineScalingGridTag.roundPixels(toRect.getWidth()) / DefineScalingGridTag.roundPixels(fromRect.getWidth());
        scale.scaleY = DefineScalingGridTag.roundPixels(toRect.getHeight()) / DefineScalingGridTag.roundPixels(fromRect.getHeight());
        Matrix toDest = Matrix.getTranslateInstance(DefineScalingGridTag.roundPixels(toRect.xMin), DefineScalingGridTag.roundPixels(toRect.yMin));
        return toOrigin.preConcatenate(scale).preConcatenate(toDest);
    }

    public RECT getRect() {
        Shape s = this.getOutline(0, 0, 0, new RenderContext(), new Matrix(), new Matrix(), true);
        if (s == null) {
            return null;
        }
        Rectangle r = s.getBounds();
        return new RECT(r.x, r.x + r.width, r.y, r.y + r.height);
    }

    public Shape getOutline(int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, Matrix prevTransform, boolean stroked) {
        CharacterTag ct = this.swf.getCharacter(this.characterId);
        if (ct == null) {
            return null;
        }
        if (!(ct instanceof DrawableTag)) {
            return null;
        }
        double[] coords = new double[6];
        DrawableTag dt = (DrawableTag)ct;
        Shape path = dt.getOutline(frame, time, ratio, renderContext, transformation, stroked);
        PathIterator iterator = path.getPathIterator(new AffineTransform());
        GeneralPath gp = new GeneralPath(0);
        ExportRectangle boundsRect = new ExportRectangle(dt.getRect());
        ExportRectangle scalingGrid = new ExportRectangle(this.splitter);
        ExportRectangle[] sourceRect = new ExportRectangle[9];
        ExportRectangle[] targetRect = new ExportRectangle[9];
        Matrix[] transforms = new Matrix[9];
        DefineScalingGridTag.getSlices(transformation.transform(boundsRect), boundsRect, scalingGrid, sourceRect, targetRect, transforms);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            block8: for (int i = 0; i < 6; i += 2) {
                double x = coords[i];
                double y = coords[i + 1];
                for (int s = 0; s < 9; ++s) {
                    Point p = new Point(x, y);
                    if (!sourceRect[s].contains(p)) continue;
                    p = transforms[s].transform(p);
                    coords[i] = p.x;
                    coords[i + 1] = p.y;
                    continue block8;
                }
            }
            switch (type) {
                case 0: {
                    gp.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    gp.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    gp.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    gp.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    gp.closePath();
                }
            }
            iterator.next();
        }
        return gp;
    }

    public static void getSlices(ExportRectangle targetBounds, ExportRectangle boundsRect, ExportRectangle scalingGrid, ExportRectangle[] sourceRect, ExportRectangle[] targetRect, Matrix[] transforms) {
        double[] src_x = new double[]{boundsRect.xMin, scalingGrid.xMin, scalingGrid.xMax, boundsRect.xMax};
        double[] dst_x = new double[]{targetBounds.xMin, targetBounds.xMin + scalingGrid.xMin, targetBounds.xMax - (boundsRect.xMax - scalingGrid.xMax), targetBounds.xMax};
        double[] src_y = new double[]{boundsRect.yMin, scalingGrid.yMin, scalingGrid.yMax, boundsRect.yMax};
        double[] dst_y = new double[]{targetBounds.yMin, targetBounds.yMin + scalingGrid.yMin, targetBounds.yMax - (boundsRect.yMax - scalingGrid.yMax), targetBounds.yMax};
        int pos = 0;
        for (int sy = 0; sy < 3; ++sy) {
            for (int sx = 0; sx < 3; ++sx) {
                sourceRect[pos] = new ExportRectangle(src_x[sx], src_y[sy], src_x[sx + 1], src_y[sy + 1]);
                targetRect[pos] = new ExportRectangle(dst_x[sx], dst_y[sy], dst_x[sx + 1], dst_y[sy + 1]);
                ++pos;
            }
        }
        for (int i = 0; i < targetRect.length; ++i) {
            transforms[i] = DefineScalingGridTag.rectToRectMatrix(sourceRect[i], targetRect[i]);
            targetRect[i].xMax = Math.rint(targetRect[i].xMax / 20.0);
            targetRect[i].yMax = Math.rint(targetRect[i].yMax / 20.0);
            targetRect[i].xMin = Math.rint(targetRect[i].xMin / 20.0);
            targetRect[i].yMin = Math.rint(targetRect[i].yMin / 20.0);
        }
    }
}

