/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagChangedListener;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=1)
public class DefineBitsTag
extends ImageTag
implements TagChangedListener {
    public static final int ID = 6;
    public static final String NAME = "DefineBits";
    @SWFType(value=BasicType.UI8)
    public ByteArrayRange jpegData;

    public DefineBitsTag(SWF swf) {
        super(swf, 6, NAME, null);
        this.characterID = swf.getNextCharacterId();
        this.jpegData = ByteArrayRange.EMPTY;
        this.forceWriteAsLong = true;
    }

    public DefineBitsTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 6, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.jpegData = sis.readByteRangeEx(sis.available(), "jpegData");
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.write(this.jpegData);
    }

    @Override
    public boolean importSupported() {
        return true;
    }

    @Override
    public void setImage(byte[] data) {
        throw new UnsupportedOperationException("Set image is not supported for DefineBits");
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.JPEG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.JPEG;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getOriginalImageData() {
        if (this.swf.getJtt() == null) return null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ByteArrayRange jttdata = this.swf.getJtt().jpegData;
            if (jttdata.getLength() != 0) {
                int jttErrorLength = DefineBitsTag.hasErrorHeader(jttdata) ? 4 : 0;
                baos.write(jttdata.getArray(), jttdata.getPos() + jttErrorLength, jttdata.getLength() - jttErrorLength);
            }
            int errorLength = DefineBitsTag.hasErrorHeader(this.jpegData) ? 4 : 0;
            baos.write(this.jpegData.getArray(), this.jpegData.getPos() + errorLength, this.jpegData.getLength() - errorLength);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    @Override
    protected SerializableImage getImage() {
        InputStream imageStream = this.getOriginalImageData();
        if (imageStream != null) {
            try {
                BufferedImage image = ImageHelper.read(imageStream);
                if (image == null) {
                    Logger.getLogger(DefineBitsTag.class.getName()).log(Level.SEVERE, "Failed to load image");
                    return null;
                }
                SerializableImage img = new SerializableImage(image);
                return img;
            }
            catch (IOException ex) {
                Logger.getLogger(DefineBitsTag.class.getName()).log(Level.SEVERE, "Failed to get image", ex);
            }
        }
        return null;
    }

    @Override
    public Dimension getImageDimension() {
        if (this.cachedImage != null) {
            return new Dimension(this.cachedImage.getWidth(), this.cachedImage.getHeight());
        }
        InputStream imageStream = this.getOriginalImageData();
        if (imageStream != null) {
            try {
                return ImageHelper.getDimesion(imageStream);
            }
            catch (IOException ex) {
                Logger.getLogger(DefineBitsJPEG3Tag.class.getName()).log(Level.SEVERE, "Failed to get image dimension", ex);
            }
        }
        return null;
    }

    @Override
    public void handleEvent(Tag tag) {
        this.clearCache();
    }
}

