/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.streams;

import com.jpexs.decompiler.flash.iggy.streams.AbstractDataStream;
import com.jpexs.decompiler.flash.iggy.streams.IggyIndexBuilder;
import com.jpexs.decompiler.flash.iggy.streams.SeekMode;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileDataStream
extends AbstractDataStream {
    private File file;
    private RandomAccessFile raf;
    private IggyIndexBuilder indexing;

    protected File getFile() {
        return this.file;
    }

    @Override
    public void setIndexing(IggyIndexBuilder indexing) {
        this.indexing = indexing;
    }

    public RandomAccessFileDataStream(File file) throws FileNotFoundException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
    }

    @Override
    public Long totalSize() {
        try {
            return this.raf.length();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Long available() {
        try {
            return this.raf.length() - this.raf.getFilePointer();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public long position() {
        try {
            return this.raf.getFilePointer();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public int read() throws IOException {
        int val = this.raf.read();
        if (val == -1) {
            throw new EOFException();
        }
        return val;
    }

    @Override
    public byte[] readBytes(int numBytes) throws IOException {
        byte[] buf = new byte[numBytes];
        this.raf.readFully(buf);
        return buf;
    }

    @Override
    public void seek(long pos, SeekMode mode) throws IOException {
        long newpos = pos;
        if (mode == SeekMode.CUR) {
            newpos = this.raf.getFilePointer() + pos;
        } else if (mode == SeekMode.END) {
            newpos = this.raf.length() - pos;
        }
        if (newpos > this.raf.length()) {
            long curpos;
            this.raf.seek(this.raf.length());
            for (long i = curpos = this.raf.length(); i < newpos; ++i) {
                this.raf.write(0);
            }
        } else {
            if (newpos < 0L) {
                throw new ArrayIndexOutOfBoundsException("Negative position accessed: " + pos);
            }
            this.raf.seek(newpos);
        }
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(int val) throws IOException {
        this.raf.write(val);
    }

    @Override
    public IggyIndexBuilder getIndexing() {
        return this.indexing;
    }

    @Override
    public boolean writeWChar(String name) throws IOException {
        return super.writeWChar(name);
    }

    @Override
    public void pad8bytes() throws IOException {
        super.pad8bytes();
    }
}

