/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.conversion;

import com.jpexs.decompiler.flash.iggy.IggyShape;
import com.jpexs.decompiler.flash.iggy.IggyShapeNode;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import java.util.ArrayList;

public class SwfShapeToIggyConvertor {
    private static float normalizeLengths(int val) {
        return (float)val / 1024.0f;
    }

    public static IggyShape convertShape(SHAPE swfShape) {
        ArrayList<IggyShapeNode> nodes = new ArrayList<IggyShapeNode>();
        RECT bounds = swfShape.getBounds();
        boolean first = true;
        float curX = 0.0f;
        float curY = 0.0f;
        for (SHAPERECORD rec : swfShape.shapeRecords) {
            if (rec instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                nodes.add(new IggyShapeNode(curX += SwfShapeToIggyConvertor.normalizeLengths(ser.deltaX), curY += SwfShapeToIggyConvertor.normalizeLengths(ser.deltaY), 0.0f, 0.0f, IggyShapeNode.NODE_TYPE_LINE_TO, 0, first));
            } else if (rec instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
                float controlX = curX + SwfShapeToIggyConvertor.normalizeLengths(cer.controlDeltaX);
                float controlY = curY + SwfShapeToIggyConvertor.normalizeLengths(cer.controlDeltaY);
                nodes.add(new IggyShapeNode(curX += SwfShapeToIggyConvertor.normalizeLengths(cer.controlDeltaX + cer.anchorDeltaX), curY += SwfShapeToIggyConvertor.normalizeLengths(cer.controlDeltaY + cer.anchorDeltaY), controlX, controlY, IggyShapeNode.NODE_TYPE_CURVE_POINT, 0, first));
            } else if (rec instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)rec;
                if (scr.stateMoveTo) {
                    curX = SwfShapeToIggyConvertor.normalizeLengths(scr.moveDeltaX);
                    curY = SwfShapeToIggyConvertor.normalizeLengths(scr.moveDeltaY);
                    nodes.add(new IggyShapeNode(curX, curY, 0.0f, 0.0f, IggyShapeNode.NODE_TYPE_MOVE, 0, first));
                }
            }
            first = false;
        }
        IggyShape ret = new IggyShape(SwfShapeToIggyConvertor.normalizeLengths(bounds.Xmin), SwfShapeToIggyConvertor.normalizeLengths(bounds.Ymin), SwfShapeToIggyConvertor.normalizeLengths(bounds.Xmax), SwfShapeToIggyConvertor.normalizeLengths(bounds.Ymax), nodes);
        return ret;
    }
}

