/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyArrayFieldType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.SeekMode;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;

public class IggyText
implements StructureInterface {
    public static final int STRUCT_SIZE = 104;
    public static final int ID = 65286;
    @IggyFieldType(value=DataType.uint16_t)
    int type;
    @IggyFieldType(value=DataType.uint16_t)
    int textIndex;
    @IggyArrayFieldType(value=DataType.uint8_t, count=28)
    byte[] zeroone;
    @IggyFieldType(value=DataType.float_t)
    float par1;
    @IggyFieldType(value=DataType.float_t)
    float par2;
    @IggyFieldType(value=DataType.float_t)
    float par3;
    @IggyFieldType(value=DataType.float_t)
    float par4;
    @IggyFieldType(value=DataType.uint16_t)
    int enum_hex;
    boolean hasText;
    boolean wordWrap;
    boolean multiline;
    boolean password;
    boolean readOnly;
    boolean hasTextColor;
    boolean hasMaxLength;
    boolean hasFont;
    boolean hasFontClass;
    boolean autosize;
    boolean hasLayout;
    boolean noSelect;
    boolean border;
    boolean wasStatic;
    boolean html;
    boolean useOutlines;
    @IggyFieldType(value=DataType.uint16_t)
    int fontIndex;
    @IggyFieldType(value=DataType.uint32_t)
    long zero;
    @IggyFieldType(value=DataType.uint64_t)
    long one;
    @IggyArrayFieldType(value=DataType.uint8_t, count=32)
    byte[] some;
    long ofs_name;
    @IggyArrayFieldType(value=DataType.wchar_t)
    String initialText;

    public IggyText(int type, int order_in_iggy_file, byte[] zeroone, float par1, float par2, float par3, float par4, int enum_hex, int for_which_font_order_in_iggyfile, long zero, long one, byte[] some, long offset_of_name, String name) {
        this.type = type;
        this.textIndex = order_in_iggy_file;
        this.zeroone = zeroone;
        this.par1 = par1;
        this.par2 = par2;
        this.par3 = par3;
        this.par4 = par4;
        this.enum_hex = enum_hex;
        this.fontIndex = for_which_font_order_in_iggyfile;
        this.zero = zero;
        this.one = one;
        this.some = some;
        this.initialText = name;
    }

    public IggyText(ReadDataStreamInterface stream) throws IOException {
        this.readFromDataStream(stream);
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface s) throws IOException {
        this.type = s.readUI16();
        this.textIndex = s.readUI16();
        this.zeroone = s.readBytes(28);
        this.par1 = s.readFloat();
        this.par2 = s.readFloat();
        this.par3 = s.readFloat();
        this.par4 = s.readFloat();
        this.enum_hex = s.readUI16();
        this.fontIndex = s.readUI16();
        this.zero = s.readUI32();
        this.one = s.readUI64();
        this.some = s.readBytes(32);
        this.ofs_name = s.readUI64();
        long name_address = this.ofs_name + s.position() - 8L;
        s.seek(name_address, SeekMode.SET);
        this.initialText = s.readWChar();
        s.pad8bytes();
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface s) throws IOException {
        s.getIndexing().writeConstLength(8);
        s.writeUI16(this.type);
        s.writeUI16(this.textIndex);
        s.writeBytes(this.zeroone);
        s.writeFloat(this.par1);
        s.writeFloat(this.par2);
        s.writeFloat(this.par3);
        s.writeFloat(this.par4);
        s.writeUI16(this.enum_hex);
        s.writeUI16(this.fontIndex);
        s.writeUI32(this.zero);
        s.writeUI64(this.one);
        s.writeBytes(this.some);
        s.writeUI64(this.ofs_name);
        long name_address = this.ofs_name + s.position() - 8L;
        s.seek(name_address, SeekMode.SET);
        s.writeWChar(this.initialText);
        s.pad8bytes();
        s.getIndexing().write16bitArray(this.initialText.length() + 1);
        s.getIndexing().pad8bytes();
    }

    public int getType() {
        return this.type;
    }

    public int getTextIndex() {
        return this.textIndex;
    }

    public byte[] getZeroone() {
        return this.zeroone;
    }

    public float getPar1() {
        return this.par1;
    }

    public float getPar2() {
        return this.par2;
    }

    public float getPar3() {
        return this.par3;
    }

    public float getPar4() {
        return this.par4;
    }

    public int getEnum_hex() {
        return this.enum_hex;
    }

    public int getFontIndex() {
        return this.fontIndex;
    }

    public long getZero() {
        return this.zero;
    }

    public long getOne() {
        return this.one;
    }

    public byte[] getSome() {
        return this.some;
    }

    public String getInitialText() {
        return this.initialText;
    }

    public void setInitialText(String initialText) {
        this.initialText = initialText;
    }
}

