/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;

public class IggyFontBinInfo
implements StructureInterface {
    public static final int STRUCT_SIZE = 96;
    @IggyFieldType(value=DataType.uint64_t)
    long size_of_this_info = 96L;
    @IggyFieldType(value=DataType.uint16_t, count=4)
    int[] font_specific;
    @IggyFieldType(value=DataType.float_t)
    float normX;
    @IggyFieldType(value=DataType.float_t)
    float zero;
    @IggyFieldType(value=DataType.float_t)
    float zero2;
    @IggyFieldType(value=DataType.float_t)
    float normY;
    @IggyFieldType(value=DataType.float_t)
    float minSize;
    @IggyFieldType(value=DataType.float_t)
    float maxSize;
    @IggyFieldType(value=DataType.uint64_t)
    long order_in_iggy_file;
    @IggyFieldType(value=DataType.int64_t)
    long address_back;
    @IggyFieldType(value=DataType.uint8_t, count=40)
    byte[] pad;

    public IggyFontBinInfo(ReadDataStreamInterface s) throws IOException {
        this.readFromDataStream(s);
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface s) throws IOException {
        this.size_of_this_info = s.readUI64();
        if (this.size_of_this_info != 96L) {
            throw new IOException(String.format("Wrong iggy font format (bininfo)!", new Object[0]));
        }
        this.font_specific = new int[4];
        for (int i = 0; i < this.font_specific.length; ++i) {
            this.font_specific[i] = s.readUI16();
        }
        this.normX = s.readFloat();
        this.zero = s.readFloat();
        this.zero2 = s.readFloat();
        this.normY = s.readFloat();
        this.minSize = s.readFloat();
        this.maxSize = s.readFloat();
        this.order_in_iggy_file = s.readUI64();
        this.address_back = s.readSI64();
        this.pad = s.readBytes(40);
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface s) throws IOException {
        s.writeUI64(this.size_of_this_info);
        for (int i = 0; i < this.font_specific.length; ++i) {
            s.writeUI16(this.font_specific[i]);
        }
        s.writeFloat(this.normX);
        s.writeFloat(this.zero);
        s.writeFloat(this.zero2);
        s.writeFloat(this.normY);
        s.writeFloat(this.minSize);
        s.writeFloat(this.maxSize);
        s.writeUI64(this.order_in_iggy_file);
        s.writeSI64(this.address_back);
        s.writeBytes(this.pad);
    }
}

