/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.IggyHeader;
import com.jpexs.decompiler.flash.iggy.IggySubFileEntry;
import com.jpexs.decompiler.flash.iggy.IggySwf;
import com.jpexs.decompiler.flash.iggy.streams.IggyIndexBuilder;
import com.jpexs.decompiler.flash.iggy.streams.RandomAccessFileDataStream;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.SeekMode;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.TemporaryDataStream;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IggyFile
implements StructureInterface {
    static final Logger LOGGER = Logger.getLogger(IggyFile.class.getName());
    private File originalFile;
    private IggyHeader header;
    private List<IggySubFileEntry> subFileEntries = new ArrayList<IggySubFileEntry>();
    private List<byte[]> subFileEntriesData = new ArrayList<byte[]>();
    private IggySwf iggySwf;
    public static final int FIRST_TAG_POSITION = 3;

    public IggySwf getSwf() {
        return this.iggySwf;
    }

    public IggyFile(String filePath) throws IOException {
        this(new File(filePath));
    }

    public IggyFile(File file) throws IOException {
        this.originalFile = file;
        try (RandomAccessFileDataStream stream = new RandomAccessFileDataStream(file);){
            this.readFromDataStream(stream);
        }
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    public IggyHeader getHeader() {
        return this.header;
    }

    public IggySubFileEntry getSubFileEntry(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.subFileEntries.size()) {
            throw new ArrayIndexOutOfBoundsException("No entry with index " + entryIndex + " exists");
        }
        return this.subFileEntries.get(entryIndex);
    }

    public int getNumEntries() {
        return this.subFileEntries.size();
    }

    public byte[] getEntryData(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.subFileEntries.size()) {
            throw new ArrayIndexOutOfBoundsException("No entry with index " + entryIndex + " exists");
        }
        return this.subFileEntriesData.get(entryIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[IggyFile:").append("\r\n");
        sb.append(this.header).append("\r\n");
        sb.append("Entries:").append("\r\n");
        for (IggySubFileEntry entry : this.subFileEntries) {
            sb.append(entry).append("\r\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void extractIggyFile(File iggyFile, File extractDir) throws IOException {
        String FILENAME_FORMAT = "index%d_type%d.bin";
        IggyFile ir = new IggyFile(iggyFile);
        for (int i = 0; i < ir.getNumEntries(); ++i) {
            IggySubFileEntry entry = ir.getSubFileEntry(i);
            try (FileOutputStream fos = new FileOutputStream(new File(extractDir, String.format("index%d_type%d.bin", i, entry.type)));){
                fos.write(ir.getEntryData(i));
                continue;
            }
        }
    }

    public String getSwfName() {
        return this.iggySwf.getName();
    }

    public long getSwfXMin() {
        return this.iggySwf.getHdr().getXMin();
    }

    public long getSwfYMin() {
        return this.iggySwf.getHdr().getYMin();
    }

    public long getSwfXMax() {
        return this.iggySwf.getHdr().getXMax();
    }

    public long getSwfYMax() {
        return this.iggySwf.getHdr().getYMax();
    }

    public float getSwfFrameRate() {
        return this.iggySwf.getHdr().getFrameRate();
    }

    public void removeIndexEntries() {
        long offsetsChange = 0L;
        int ENTRY_SIZE = 16;
        for (int i = 0; i < this.subFileEntries.size(); ++i) {
            IggySubFileEntry entry = this.subFileEntries.get(i);
            entry.offset += offsetsChange;
            if (entry.type != 0L) continue;
            offsetsChange = offsetsChange - entry.size - 16L;
            this.subFileEntriesData.remove(i);
            this.subFileEntries.remove(i);
            --i;
        }
    }

    public boolean updateFlashEntry() throws IOException {
        byte[] replacementIndexData;
        byte[] replacementData;
        IggyIndexBuilder ib = new IggyIndexBuilder();
        try (TemporaryDataStream stream = new TemporaryDataStream();){
            stream.setIndexing(ib);
            this.iggySwf.writeToDataStream(stream);
            replacementData = stream.getAllBytes();
            replacementIndexData = ib.getIndexBytes();
        }
        catch (IOException ex) {
            Logger.getLogger(IggyFile.class.getName()).log(Level.SEVERE, "Error during updating SWF", ex);
            return false;
        }
        long offsetsChange = 0L;
        for (int i = 0; i < this.subFileEntries.size(); ++i) {
            long newSize;
            IggySubFileEntry entry = this.subFileEntries.get(i);
            entry.offset += offsetsChange;
            if (entry.type != 1L) continue;
            long oldSize = entry.size;
            entry.size = newSize = (long)replacementData.length;
            entry.size2 = newSize;
            offsetsChange += newSize - oldSize;
            this.subFileEntriesData.set(i, replacementData);
        }
        this.removeIndexEntries();
        IggySubFileEntry indexEntry = new IggySubFileEntry(0L, replacementIndexData.length, replacementIndexData.length, 0L);
        this.subFileEntries.add(indexEntry);
        this.subFileEntriesData.add(replacementIndexData);
        return true;
    }

    private void parseEntries() throws IOException {
        for (int i = 0; i < this.subFileEntries.size(); ++i) {
            IggySubFileEntry entry = this.subFileEntries.get(i);
            if (entry.type != 1L) continue;
            this.iggySwf = new IggySwf(new TemporaryDataStream(this.getEntryData(i)));
            break;
        }
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface stream) throws IOException {
        this.header = new IggyHeader(stream);
        if (!this.header.is64()) {
            throw new IOException("32 bit iggy files are not (yet) supported, sorry");
        }
        int i = 0;
        while ((long)i < this.header.getNumSubfiles()) {
            this.subFileEntries.add(new IggySubFileEntry(stream));
            ++i;
        }
        for (IggySubFileEntry entry : this.subFileEntries) {
            stream.seek(entry.offset, SeekMode.SET);
            byte[] entryData = stream.readBytes((int)entry.size);
            this.subFileEntriesData.add(entryData);
        }
        this.parseEntries();
    }

    public void saveChanges() throws IOException {
        this.updateFlashEntry();
        try (RandomAccessFileDataStream raf = new RandomAccessFileDataStream(this.originalFile);){
            this.writeToDataStream(raf);
        }
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface stream) throws IOException {
        int i;
        long startOffset;
        this.header.writeToDataStream(stream);
        long currentOffset = startOffset = (long)(IggyHeader.STRUCT_SIZE + 16 * this.subFileEntries.size());
        for (i = 0; i < this.subFileEntries.size(); ++i) {
            IggySubFileEntry entry = this.subFileEntries.get(i);
            entry.offset = currentOffset;
            currentOffset += entry.size;
            entry.writeToDataStream(stream);
        }
        for (i = 0; i < this.subFileEntries.size(); ++i) {
            byte[] entryData = this.subFileEntriesData.get(i);
            stream.writeBytes(entryData);
        }
    }
}

