/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;
import java.util.logging.Logger;

public class IggyCharOffset
implements StructureInterface {
    public static final int STRUCT_SIZE = 32;
    private static Logger LOGGER = Logger.getLogger(IggyCharOffset.class.getName());
    @IggyFieldType(value=DataType.uint64_t)
    long zero;
    @IggyFieldType(value=DataType.uint16_t)
    int ischar1;
    @IggyFieldType(value=DataType.uint16_t)
    int ischar2;
    @IggyFieldType(value=DataType.uint32_t)
    long zero2;
    @IggyFieldType(value=DataType.uint16_t)
    int xscale;
    @IggyFieldType(value=DataType.uint16_t)
    int yscale;
    @IggyFieldType(value=DataType.uint32_t)
    long zero3;
    @IggyFieldType(value=DataType.uint64_t)
    long offset;

    public IggyCharOffset(ReadDataStreamInterface stream) throws IOException {
        this.readFromDataStream(stream);
    }

    public IggyCharOffset(int ischar1, int ischar2, int xscale, int yscale) {
        this.zero = 0L;
        this.ischar1 = ischar1;
        this.ischar2 = ischar2;
        this.zero2 = 0L;
        this.xscale = xscale;
        this.yscale = yscale;
        this.zero3 = 0L;
        this.offset = 0L;
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface stream) throws IOException {
        this.zero = stream.readUI64();
        this.ischar1 = stream.readUI16();
        this.ischar2 = stream.readUI16();
        this.zero2 = stream.readUI32();
        this.xscale = stream.readUI16();
        this.yscale = stream.readUI16();
        this.zero3 = stream.readUI32();
        this.offset = stream.readUI64();
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface stream) throws IOException {
        stream.writeUI64(this.zero);
        stream.writeUI16(this.ischar1);
        stream.writeUI16(this.ischar2);
        stream.writeUI32(this.zero2);
        stream.writeUI16(this.xscale);
        stream.writeUI16(this.yscale);
        stream.writeUI32(this.zero3);
        stream.writeUI64(this.offset);
    }

    public boolean hasGlyph() {
        return this.offset > 0L;
    }

    public long getZero() {
        return this.zero;
    }

    public boolean isChar1() {
        return this.ischar1 > 0;
    }

    public boolean isChar2() {
        return this.ischar2 > 0;
    }

    public long getZero2() {
        return this.zero2;
    }

    public int getXscale() {
        return this.xscale;
    }

    public int getYscale() {
        return this.yscale;
    }

    public long getZero3() {
        return this.zero3;
    }
}

