/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerListener;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.plugin.CharSequenceJavaFileObject;
import com.jpexs.helpers.plugin.ClassFileManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class SWFDecompilerPlugin {
    private static final Logger logger = Logger.getLogger(SWFDecompilerPlugin.class.getName());
    private static final List<SWFDecompilerListener> listeners = new ArrayList<SWFDecompilerListener>();
    public static String[] customParameters = new String[0];

    public static File getPluginsDir() {
        File pluginPath = null;
        try {
            String pluginPathConfig = Configuration.pluginPath.get();
            if (pluginPathConfig != null && !pluginPathConfig.isEmpty()) {
                pluginPath = new File(pluginPathConfig);
            }
            if (pluginPath == null || !pluginPath.exists()) {
                File f = new File(SWFDecompilerPlugin.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                File dir = f.getAbsoluteFile().getParentFile().getParentFile();
                pluginPath = new File(Path.combine(dir.getPath(), "plugins")).getCanonicalFile();
            }
        }
        catch (IOException | URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return pluginPath;
    }

    public static void loadPlugins() {
        File pluginPath = SWFDecompilerPlugin.getPluginsDir();
        if (pluginPath != null && pluginPath.exists()) {
            System.out.println("Loading plugins from " + pluginPath.getPath());
            File[] files = pluginPath.listFiles();
            if (files != null) {
                for (File file : files) {
                    System.out.println("Loading plugin: " + file.getPath());
                    SWFDecompilerPlugin.loadPlugin(file.getPath());
                }
            }
        }
    }

    public static void loadPlugin(String path) {
        if (".class".equals(Path.getExtension(path))) {
            SWFDecompilerPlugin.loadPluginCompiled(path);
        } else {
            SWFDecompilerPlugin.loadPluginSource(path);
        }
    }

    private static void loadPluginCompiled(String path) {
        File pluginFile = new File(path);
        File file = pluginFile.getParentFile();
        try {
            URL url = file.toURI().toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader cl = new URLClassLoader(urls);
            String pluginName = Path.getFileNameWithoutExtension(pluginFile);
            Class<?> cls = cl.loadClass(pluginName);
            if (SWFDecompilerListener.class.isAssignableFrom(cls)) {
                SWFDecompilerListener listener = (SWFDecompilerListener)cls.newInstance();
                listeners.add(listener);
            }
            System.out.println("Plugin loaded: " + pluginName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private static void loadPluginSource(String path) {
        String src = Helper.readTextFile(path);
        int idx = src.indexOf("public class ");
        String fullName = src.substring(idx + 13);
        fullName = fullName.substring(0, fullName.indexOf(32)).trim();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            logger.log(Level.SEVERE, "Compiler is null");
            return;
        }
        ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
        ArrayList<CharSequenceJavaFileObject> jfiles = new ArrayList<CharSequenceJavaFileObject>();
        jfiles.add(new CharSequenceJavaFileObject(fullName, src));
        compiler.getTask(null, fileManager, null, null, null, jfiles).call();
        try {
            listeners.add((SWFDecompilerListener)fileManager.getClassLoader(null).loadClass(fullName).newInstance());
            System.out.println("Plugin loaded: " + fullName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static byte[] fireProxyFileCatched(byte[] data) {
        byte[] result = null;
        for (SWFDecompilerListener listener : listeners) {
            try {
                byte[] newResult = listener.proxyFileCatched(data);
                if (newResult == null) continue;
                result = newResult;
                data = newResult;
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to call plugin method proxyFileCatched.", e);
            }
        }
        return result;
    }

    public static boolean fireSwfParsed(SWF swf) {
        for (SWFDecompilerListener listener : listeners) {
            try {
                listener.swfParsed(swf);
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to call plugin method swfParsed.", e);
            }
        }
        return !listeners.isEmpty();
    }

    public static boolean fireActionListParsed(ActionList actions, SWF swf) throws InterruptedException {
        for (SWFDecompilerListener listener : listeners) {
            try {
                listener.actionListParsed(actions, swf);
            }
            catch (InterruptedException | ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to call plugin method actionListParsed.", e);
            }
        }
        return !listeners.isEmpty();
    }

    public static boolean fireActionTreeCreated(List<GraphTargetItem> tree, SWF swf) throws InterruptedException {
        for (SWFDecompilerListener listener : listeners) {
            try {
                listener.actionTreeCreated(tree, swf);
            }
            catch (InterruptedException | ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to call plugin method actionTreeCreated.", e);
            }
        }
        return !listeners.isEmpty();
    }

    public static boolean fireAbcParsed(ABC abc, SWF swf) {
        for (SWFDecompilerListener listener : listeners) {
            try {
                listener.abcParsed(abc, swf);
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to call plugin method abcParsed.", e);
            }
        }
        return !listeners.isEmpty();
    }

    public static boolean fireMethodBodyParsed(ABC abc, MethodBody body, SWF swf) {
        for (SWFDecompilerListener listener : listeners) {
            try {
                listener.methodBodyParsed(abc, body, swf);
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to call plugin method methodBodyParsed.", e);
            }
        }
        return !listeners.isEmpty();
    }

    public static boolean fireAvm2CodeRemoveTraps(String path, int classIndex, boolean isStatic, int scriptIndex, ABC abc, Trait trait, int methodInfo, MethodBody body) throws InterruptedException {
        for (SWFDecompilerListener listener : listeners) {
            try {
                listener.avm2CodeRemoveTraps(path, classIndex, isStatic, scriptIndex, abc, trait, methodInfo, body);
            }
            catch (InterruptedException | ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to call plugin method abcParsed.", e);
            }
        }
        return !listeners.isEmpty();
    }
}

