/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.GraphSourceItemPosition;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightType;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class HighlightedTextWriter
extends GraphTextWriter {
    private final StringBuilder sb = new StringBuilder();
    private final boolean hilight;
    private boolean newLine = true;
    private int indent = 0;
    private final Stack<GraphSourceItemPosition> offsets = new Stack();
    private boolean toStringCalled = false;
    private int newLineCount = 0;
    private final Stack<Highlighting> hilightStack = new Stack();
    public List<Highlighting> traitHilights = new ArrayList<Highlighting>();
    public List<Highlighting> classHilights = new ArrayList<Highlighting>();
    public List<Highlighting> methodHilights = new ArrayList<Highlighting>();
    public List<Highlighting> instructionHilights = new ArrayList<Highlighting>();
    public List<Highlighting> specialHilights = new ArrayList<Highlighting>();

    public HighlightedTextWriter(CodeFormatting formatting, boolean hilight) {
        super(formatting);
        this.hilight = hilight;
    }

    public HighlightedTextWriter(CodeFormatting formatting, boolean hilight, int indent) {
        super(formatting);
        this.hilight = hilight;
        this.indent = indent;
    }

    @Override
    public boolean getIsHighlighted() {
        return this.hilight;
    }

    @Override
    public HighlightedTextWriter startOffset(GraphSourceItem src, GraphSourceItem startLineItem, int pos, HighlightData data) {
        GraphSourceItemPosition itemPos = new GraphSourceItemPosition();
        itemPos.graphSourceItem = src;
        itemPos.startLineItem = startLineItem;
        itemPos.position = pos;
        itemPos.data = data;
        this.offsets.add(itemPos);
        return this;
    }

    @Override
    public HighlightedTextWriter endOffset() {
        this.offsets.pop();
        return this;
    }

    @Override
    public HighlightedTextWriter startMethod(long index) {
        HighlightData data = new HighlightData();
        data.index = index;
        return this.start(data, HighlightType.METHOD);
    }

    @Override
    public HighlightedTextWriter startFunction(String name) {
        HighlightData data = new HighlightData();
        data.localName = name;
        return this.start(data, HighlightType.METHOD);
    }

    @Override
    public HighlightedTextWriter endMethod() {
        return this.end(HighlightType.METHOD);
    }

    @Override
    public HighlightedTextWriter endFunction() {
        return this.end(HighlightType.METHOD);
    }

    @Override
    public HighlightedTextWriter startClass(long index) {
        HighlightData data = new HighlightData();
        data.index = index;
        return this.start(data, HighlightType.CLASS);
    }

    @Override
    public HighlightedTextWriter startClass(String className) {
        HighlightData data = new HighlightData();
        data.localName = className;
        return this.start(data, HighlightType.CLASS);
    }

    @Override
    public HighlightedTextWriter endClass() {
        return this.end(HighlightType.CLASS);
    }

    @Override
    public HighlightedTextWriter startTrait(long index) {
        HighlightData data = new HighlightData();
        data.index = index;
        return this.start(data, HighlightType.TRAIT);
    }

    @Override
    public HighlightedTextWriter endTrait() {
        return this.end(HighlightType.TRAIT);
    }

    @Override
    protected HighlightedTextWriter hilightSpecial(String text, HighlightSpecialType type, String specialValue, HighlightData data) {
        HighlightData ndata = new HighlightData();
        ndata.merge(data);
        ndata.subtype = type;
        ndata.specialValue = specialValue;
        this.start(ndata, HighlightType.SPECIAL);
        this.appendNoHilight(text);
        return this.end(HighlightType.SPECIAL);
    }

    @Override
    public HighlightedTextWriter append(String str) {
        return this.appendWithData(str, null);
    }

    @Override
    public HighlightedTextWriter appendWithData(String str, HighlightData data) {
        Highlighting h = null;
        if (!this.offsets.empty()) {
            GraphSourceItemPosition itemPos = this.offsets.peek();
            GraphSourceItem src = itemPos.graphSourceItem;
            int pos = itemPos.position;
            if (src != null && this.hilight) {
                HighlightData ndata = new HighlightData();
                ndata.merge(itemPos.data);
                ndata.merge(data);
                ndata.offset = src.getAddress() + (long)pos;
                ndata.fileOffset = src.getFileOffset();
                if (itemPos.startLineItem != null) {
                    ndata.firstLineOffset = itemPos.startLineItem.getLineOffset();
                }
                h = new Highlighting(this.sb.length() - this.newLineCount, ndata, HighlightType.OFFSET, str);
                this.instructionHilights.add(h);
            }
        }
        this.appendToSb(str);
        this.fixNewLineCount(str);
        if (h != null) {
            h.len = this.sb.length() - this.newLineCount - h.startPos;
        }
        return this;
    }

    @Override
    public HighlightedTextWriter append(String str, long offset, long fileOffset) {
        Highlighting h = null;
        if (this.hilight) {
            HighlightData data = new HighlightData();
            data.offset = offset;
            data.fileOffset = fileOffset;
            h = new Highlighting(this.sb.length() - this.newLineCount, data, HighlightType.OFFSET, str);
            this.instructionHilights.add(h);
        }
        this.appendToSb(str);
        if (h != null) {
            h.len = this.sb.length() - this.newLineCount - h.startPos;
        }
        return this;
    }

    @Override
    public HighlightedTextWriter appendNoHilight(int i) {
        this.appendNoHilight(Integer.toString(i));
        return this;
    }

    @Override
    public HighlightedTextWriter appendNoHilight(String str) {
        this.appendToSb(str);
        return this;
    }

    @Override
    public HighlightedTextWriter indent() {
        ++this.indent;
        return this;
    }

    @Override
    public HighlightedTextWriter unindent() {
        --this.indent;
        return this;
    }

    @Override
    public HighlightedTextWriter newLine() {
        this.appendToSb(this.formatting.newLineChars);
        this.newLine = true;
        ++this.newLineCount;
        return this;
    }

    @Override
    public int getLength() {
        return this.sb.length();
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public String toString() {
        long stopTime;
        long time;
        if (this.toStringCalled) {
            throw new Error("HighlightedTextWriter.toString() was already called.");
        }
        if (Configuration._debugMode.get().booleanValue() && (time = (stopTime = System.currentTimeMillis()) - this.startTime) > 500L) {
            System.out.println("Rendering is too slow: " + Helper.formatTimeSec(time) + " length: " + this.sb.length());
        }
        this.toStringCalled = true;
        return this.sb.toString();
    }

    private HighlightedTextWriter start(HighlightData data, HighlightType type) {
        if (this.hilight) {
            Highlighting h = new Highlighting(this.sb.length() - this.newLineCount, data, type, null);
            this.hilightStack.add(h);
        }
        return this;
    }

    private HighlightedTextWriter end(HighlightType expectedType) {
        if (this.hilight) {
            Highlighting h = this.hilightStack.pop();
            h.len = this.sb.length() - this.newLineCount - h.startPos;
            if (!expectedType.equals((Object)h.type)) {
                throw new Error("Hilighting mismatch.");
            }
            switch (h.type) {
                case CLASS: {
                    this.classHilights.add(h);
                    break;
                }
                case METHOD: {
                    this.methodHilights.add(h);
                    break;
                }
                case TRAIT: {
                    this.traitHilights.add(h);
                    break;
                }
                case SPECIAL: {
                    this.specialHilights.add(h);
                    break;
                }
                case OFFSET: {
                    this.instructionHilights.add(h);
                }
            }
        }
        return this;
    }

    private void appendToSb(String str) {
        if (this.newLine) {
            this.newLine = false;
            this.appendIndent();
        }
        this.sb.append(str);
    }

    private void fixNewLineCount(String str) {
        int nl = 0;
        int rn = 0;
        int prevChar = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\r' || ch == '\n') {
                ++rn;
            }
            if (ch == '\r' || prevChar != 13 && ch == '\n') {
                ++nl;
            }
            prevChar = ch;
        }
        this.newLineCount += rn - nl;
    }

    private void appendIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.appendNoHilight(this.formatting.indentString);
        }
    }
}

