/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CallPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConstructPropAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.InitPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewArrayAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.DeclarationAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.ExportPackTask;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class AS3ScriptExporter {
    private static final Logger logger = Logger.getLogger(AS3ScriptExporter.class.getName());

    private static String prettyFormatXML(String input) {
        int indent = 5;
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError e) {
            logger.log(Level.SEVERE, "Pretty print error", e);
            return input;
        }
    }

    private String handleMxmlMethod(Map<String, String> namespaces, ScriptPack pack, int cindex, TraitMethodGetterSetter t) {
        StringBuilder out;
        block7: {
            out = new StringBuilder();
            int method = t.method_info;
            try {
                GraphTargetItem asg;
                pack.abc.findBody(method).convert(new ConvertData(), "??", ScriptExportMode.AS, false, method, pack.scriptIndex, cindex, pack.abc, t, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true);
                List<GraphTargetItem> ci = pack.abc.findBody((int)method).convertedItems;
                if (ci.isEmpty() || !(ci.get(0) instanceof DeclarationAVM2Item) || !((asg = ((DeclarationAVM2Item)ci.get((int)0)).assignment) instanceof SetLocalAVM2Item) || !(asg.value instanceof CoerceAVM2Item) || !(asg.value.value instanceof ConstructPropAVM2Item)) break block7;
                ConstructPropAVM2Item cp = (ConstructPropAVM2Item)asg.value.value;
                if (!(cp.propertyName instanceof FullMultinameAVM2Item)) break block7;
                int name = ((FullMultinameAVM2Item)cp.propertyName).multinameIndex;
                String tagName = this.getTagName(pack, name, name, namespaces);
                StringBuilder props = new StringBuilder();
                StringBuilder tagContent = new StringBuilder();
                for (int i = 1; i < ci.size(); ++i) {
                    if (!(ci.get(i) instanceof SetPropertyAVM2Item)) continue;
                    SetPropertyAVM2Item sp = (SetPropertyAVM2Item)ci.get(i);
                    if (!(sp.object instanceof LocalRegAVM2Item) || ((SetLocalAVM2Item)asg).regIndex != ((LocalRegAVM2Item)sp.object).regIndex) continue;
                    GraphTargetItem val = sp.value;
                    if (!(sp.propertyName instanceof FullMultinameAVM2Item)) continue;
                    String propName = pack.abc.constants.getMultiname(((FullMultinameAVM2Item)sp.propertyName).multinameIndex).getName(pack.abc.constants, new ArrayList<DottedChain>(), true, true);
                    if (val instanceof CallPropertyAVM2Item) {
                        CallPropertyAVM2Item cap = (CallPropertyAVM2Item)val;
                        if (!(cp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        int name2 = ((FullMultinameAVM2Item)cap.propertyName).multinameIndex;
                        for (Trait ct : pack.abc.instance_info.get((int)cindex).instance_traits.traits) {
                            if (ct.name_index != name2 || !(ct instanceof TraitMethodGetterSetter)) continue;
                            tagContent.append(this.handleMxmlMethod(namespaces, pack, cindex, (TraitMethodGetterSetter)ct));
                        }
                        continue;
                    }
                    if (val instanceof ConstructPropAVM2Item) continue;
                    props.append(" ").append(propName).append("=\"").append(EcmaScript.toString(val.getResult())).append("\"");
                }
                out.append("<").append(tagName).append((CharSequence)props);
                if (tagContent.length() > 0) {
                    out.append(">");
                    out.append((CharSequence)tagContent);
                    out.append("</").append(tagName).append(">");
                } else {
                    out.append(" />");
                }
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return out.toString();
    }

    private String handleMxmlArrMethod(Map<String, String> namespaces, ScriptPack pack, int cindex, TraitMethodGetterSetter t) {
        StringBuilder out = new StringBuilder();
        int method = t.method_info;
        try {
            GraphTargetItem asg;
            pack.abc.findBody(method).convert(new ConvertData(), "??", ScriptExportMode.AS, false, method, pack.scriptIndex, cindex, pack.abc, t, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true);
            List<GraphTargetItem> ci = pack.abc.findBody((int)method).convertedItems;
            if (!ci.isEmpty() && ci.get(0) instanceof DeclarationAVM2Item && (asg = ((DeclarationAVM2Item)ci.get((int)0)).assignment) instanceof SetLocalAVM2Item && ((SetLocalAVM2Item)asg).value.getNotCoerced() instanceof NewArrayAVM2Item) {
                NewArrayAVM2Item nav = (NewArrayAVM2Item)((SetLocalAVM2Item)asg).value.getNotCoerced();
                for (GraphTargetItem v : nav.values) {
                    if (!(v instanceof CallPropertyAVM2Item)) continue;
                    CallPropertyAVM2Item cp = (CallPropertyAVM2Item)v;
                    if (!(cp.receiver instanceof ThisAVM2Item) || !(cp.propertyName instanceof FullMultinameAVM2Item)) continue;
                    int name = ((FullMultinameAVM2Item)cp.propertyName).multinameIndex;
                    for (Trait ct : pack.abc.instance_info.get((int)cindex).instance_traits.traits) {
                        if (ct.name_index != name || !(ct instanceof TraitMethodGetterSetter)) continue;
                        out.append(this.handleMxmlMethod(namespaces, pack, cindex, (TraitMethodGetterSetter)ct));
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return out.toString();
    }

    private String getTagName(ScriptPack pack, int classMIndex, int nameMindex, Map<String, String> namespaces) {
        Multiname m = pack.abc.constants.getMultiname(classMIndex);
        Multiname mn = pack.abc.constants.getMultiname(nameMindex);
        String parentName = mn.getName(pack.abc.constants, new ArrayList<DottedChain>(), true, true);
        String pkg = m.getNamespace(pack.abc.constants).getName(pack.abc.constants).toRawString();
        pkg = pkg + ".*";
        String ns = null;
        if (pkg.startsWith("spark.")) {
            ns = "s";
            pkg = "library://ns.adobe.com/flex/spark";
            namespaces.put(ns, pkg);
        } else if (pkg.startsWith("mx.")) {
            ns = "mx";
            pkg = "library://ns.adobe.com/flex/mx";
            namespaces.put(ns, pkg);
        } else if (namespaces.containsValue(pkg)) {
            for (String k : namespaces.keySet()) {
                if (!namespaces.get(k).equals(pkg)) continue;
                ns = k;
                break;
            }
        } else {
            String baseNs;
            ns = baseNs = "pkg";
            int i = 1;
            ++i;
            while (namespaces.containsKey(ns)) {
                ns = baseNs + i;
                ++i;
            }
            namespaces.put(ns, pkg);
        }
        return ns + ":" + parentName;
    }

    private String generateMxml(ScriptPack pack) {
        StringBuilder out = new StringBuilder();
        StringBuilder tagProp = new StringBuilder();
        StringBuilder tagContent = new StringBuilder();
        String hdr = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + System.lineSeparator();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("fx", "http://ns.adobe.com/mxml/2009");
        for (int ti : pack.traitIndices) {
            Trait t = pack.abc.script_info.get((int)pack.scriptIndex).traits.traits.get(ti);
            if (!(t instanceof TraitClass)) continue;
            int cindex = ((TraitClass)t).class_info;
            int mindex = pack.abc.instance_info.get((int)cindex).super_index;
            String tagName = this.getTagName(pack, mindex, mindex, namespaces);
            int iinit = pack.abc.instance_info.get((int)cindex).iinit_index;
            try {
                pack.abc.findBody(iinit).convert(new ConvertData(), "??", ScriptExportMode.AS, false, iinit, pack.scriptIndex, cindex, pack.abc, t, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true);
                List<GraphTargetItem> iinitBody = pack.abc.findBody((int)iinit).convertedItems;
                for (GraphTargetItem it : iinitBody) {
                    AVM2Item cp;
                    if (!(it instanceof InitPropertyAVM2Item)) continue;
                    InitPropertyAVM2Item ip = (InitPropertyAVM2Item)it;
                    if (!(ip.object instanceof ThisAVM2Item)) continue;
                    String propName = pack.abc.constants.getMultiname(ip.propertyName.multinameIndex).getName(pack.abc.constants, new ArrayList<DottedChain>(), true, true);
                    GraphTargetItem val = ((InitPropertyAVM2Item)it).value;
                    if (val instanceof CallPropertyAVM2Item) {
                        cp = (CallPropertyAVM2Item)val;
                        if (!(cp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        String subtagName = this.getTagName(pack, mindex, ip.propertyName.multinameIndex, namespaces);
                        tagContent.append("<").append(subtagName).append(">");
                        int name = ((FullMultinameAVM2Item)cp.propertyName).multinameIndex;
                        for (Trait ct : pack.abc.instance_info.get((int)cindex).instance_traits.traits) {
                            if (ct.name_index != name || !(ct instanceof TraitMethodGetterSetter)) continue;
                            tagContent.append(this.handleMxmlMethod(namespaces, pack, cindex, (TraitMethodGetterSetter)ct));
                        }
                        tagContent.append("</").append(subtagName).append(">");
                        continue;
                    }
                    if (val instanceof ConstructPropAVM2Item) {
                        cp = (ConstructPropAVM2Item)val;
                        if (!(((ConstructPropAVM2Item)cp).propertyName instanceof FullMultinameAVM2Item)) continue;
                        Multiname m = pack.abc.constants.getMultiname(((FullMultinameAVM2Item)((ConstructPropAVM2Item)cp).propertyName).multinameIndex);
                        if (!"mx.core.DeferredInstanceFromFunction".equals("" + m.getNameWithNamespace(pack.abc.constants, true)) || ((ConstructPropAVM2Item)cp).args.isEmpty() || !(((ConstructPropAVM2Item)cp).args.get(0) instanceof GetPropertyAVM2Item)) continue;
                        GetPropertyAVM2Item gp = (GetPropertyAVM2Item)((ConstructPropAVM2Item)cp).args.get(0);
                        if (!(gp.object instanceof ThisAVM2Item)) continue;
                        int name = ((FullMultinameAVM2Item)gp.propertyName).multinameIndex;
                        for (Trait ct : pack.abc.instance_info.get((int)cindex).instance_traits.traits) {
                            if (ct.name_index != name || !(ct instanceof TraitMethodGetterSetter)) continue;
                            tagContent.append(this.handleMxmlArrMethod(namespaces, pack, cindex, (TraitMethodGetterSetter)ct));
                        }
                        continue;
                    }
                    tagProp.append(" ").append(propName).append("=\"").append(EcmaScript.toString(val.getResult())).append("\"");
                }
                out.append("<").append(tagName);
                for (String ns : namespaces.keySet()) {
                    out.append(" xmlns:").append(ns).append("=\"").append((String)namespaces.get(ns)).append("\"");
                }
                if (tagContent.length() == 0) {
                    out.append(" />");
                    continue;
                }
                out.append((CharSequence)tagProp).append(">");
                out.append((CharSequence)tagContent);
                out.append("</").append(tagName).append(">");
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return hdr + AS3ScriptExporter.prettyFormatXML(out.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> exportActionScript3(SWF swf, AbortRetryIgnoreHandler handler, String outdir, List<ScriptPack> as3scripts, ScriptExportSettings exportSettings, boolean parallel, EventListener evl) {
        final ArrayList<File> ret = new ArrayList<File>();
        List<ScriptPack> packs = as3scripts != null ? as3scripts : swf.getAS3Packs();
        ArrayList<String> ignoredClasses = new ArrayList<String>();
        ArrayList<String> ignoredNss = new ArrayList<String>();
        String flexClass = null;
        if (Configuration._enableFlexExport.get().booleanValue()) {
            flexClass = swf.getFlexMainClass(ignoredClasses, ignoredNss);
        }
        int cnt = 1;
        final ArrayList<ExportPackTask> tasks = new ArrayList<ExportPackTask>();
        HashSet<String> files = new HashSet<String>();
        for (ScriptPack item : packs) {
            String filePath;
            Object file;
            if (!item.isSimple && Configuration.ignoreCLikePackages.get().booleanValue() || ignoredClasses.contains(item.getClassPath().toRawString())) continue;
            if (flexClass != null && item.getClassPath().toRawString().equals(flexClass)) {
                file = item.getExportFile(outdir, ".mxml");
                filePath = ((File)file).getPath();
                String mxml = this.generateMxml(item);
                if (mxml != null) {
                    Helper.writeFile(filePath, new byte[][]{Utf8Helper.getBytes(mxml)});
                    files.add(filePath.toLowerCase());
                    continue;
                }
            }
            file = null;
            if (!exportSettings.singleFile) {
                file = item.getExportFile(outdir, exportSettings);
                filePath = ((File)file).getPath();
                if (files.contains(filePath.toLowerCase())) {
                    String parentPath = ((File)file).getParent();
                    String fileName = ((File)file).getName();
                    String extension = Path.getExtension(fileName);
                    String fileNameWithoutExtension = Path.getFileNameWithoutExtension((File)file);
                    int i = 2;
                    while (files.contains((filePath = Path.combine(parentPath, fileNameWithoutExtension + "_" + i++ + extension)).toLowerCase())) {
                    }
                    file = new File(filePath);
                }
                files.add(filePath.toLowerCase());
            }
            tasks.add(new ExportPackTask(handler, cnt++, packs.size(), item.getClassPath(), item, (File)file, exportSettings, parallel, evl));
        }
        if (!parallel || tasks.size() < 2) {
            try {
                CancellableWorker.call(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (ExportPackTask task : tasks) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new InterruptedException();
                            }
                            ret.add(task.call());
                        }
                        return null;
                    }
                }, Configuration.exportTimeout.get().intValue(), TimeUnit.SECONDS);
            }
            catch (TimeoutException ex) {
                logger.log(Level.SEVERE, Helper.formatTimeToText(Configuration.exportTimeout.get()) + " ActionScript export limit reached", ex);
            }
            catch (InterruptedException | ExecutionException ex) {
                logger.log(Level.SEVERE, "Error during ABC export", ex);
            }
        } else {
            ExecutorService executor = Executors.newFixedThreadPool(Configuration.getParallelThreadCount());
            ArrayList<Future<File>> futureResults = new ArrayList<Future<File>>();
            for (ExportPackTask task : tasks) {
                Future<File> future = executor.submit(task);
                futureResults.add(future);
            }
            try {
                executor.shutdown();
                if (!executor.awaitTermination(Configuration.exportTimeout.get().intValue(), TimeUnit.SECONDS)) {
                    logger.log(Level.SEVERE, Helper.formatTimeToText(Configuration.exportTimeout.get()) + " ActionScript export limit reached");
                }
            }
            catch (InterruptedException file) {
            }
            finally {
                executor.shutdownNow();
            }
            for (int f = 0; f < futureResults.size(); ++f) {
                try {
                    if (!((Future)futureResults.get(f)).isDone()) continue;
                    ret.add((File)((Future)futureResults.get(f)).get());
                    continue;
                }
                catch (InterruptedException task) {
                    continue;
                }
                catch (ExecutionException ex) {
                    logger.log(Level.SEVERE, "Error during ABC export", ex);
                }
            }
        }
        return ret;
    }
}

