/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.commonshape;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.modes.FontExportMode;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.helpers.Helper;
import java.awt.Color;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGExporter {
    protected static final String sNamespace = "http://www.w3.org/2000/svg";
    protected static final String xlinkNamespace = "http://www.w3.org/1999/xlink";
    protected Document _svg;
    protected Element _svgDefs;
    protected CDATASection _svgStyle;
    protected Stack<Element> _svgGs = new Stack();
    public List<Element> gradients;
    protected int lastPatternId;
    public Map<Tag, String> exportedTags = new HashMap<Tag, String>();
    public Map<Tag, Map<Character, String>> exportedChars = new HashMap<Tag, Map<Character, String>>();
    private final Map<String, Integer> lastIds = new HashMap<String, Integer>();
    private final HashSet<String> fontFaces = new HashSet();
    public boolean useTextTag = Configuration.textExportExportFontFace.get();

    public SVGExporter(ExportRectangle bounds, double zoom) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            DOMImplementation impl = docBuilder.getDOMImplementation();
            DocumentType svgDocType = impl.createDocumentType("svg", "-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
            this._svg = impl.createDocument(sNamespace, "svg", svgDocType);
            Element svgRoot = this._svg.getDocumentElement();
            svgRoot.setAttribute("xmlns:xlink", xlinkNamespace);
            if (bounds != null) {
                svgRoot.setAttribute("width", bounds.getWidth() / 20.0 + "px");
                svgRoot.setAttribute("height", bounds.getHeight() / 20.0 + "px");
                this.createDefGroup(bounds, null, zoom);
            }
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(SVGExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.gradients = new ArrayList<Element>();
    }

    private Element getDefs() {
        if (this._svgDefs == null) {
            this._svgDefs = this._svg.createElement("defs");
            this._svg.getDocumentElement().appendChild(this._svgDefs);
        }
        return this._svgDefs;
    }

    private CDATASection getStyle() {
        if (this._svgStyle == null) {
            Element style = this._svg.createElement("style");
            this._svgStyle = this._svg.createCDATASection("");
            style.appendChild(this._svgStyle);
            this.getDefs().appendChild(style);
        }
        return this._svgStyle;
    }

    public final void createDefGroup(ExportRectangle bounds, String id) {
        this.createDefGroup(bounds, id, 1.0);
    }

    public final void createDefGroup(ExportRectangle bounds, String id, double zoom) {
        Element g = this._svg.createElement("g");
        if (bounds != null) {
            Matrix mat = Matrix.getTranslateInstance(-bounds.xMin, -bounds.yMin);
            mat.scale(zoom);
            g.setAttribute("transform", mat.getSvgTransformationString(20.0, 1.0));
        }
        if (id != null) {
            g.setAttribute("id", id);
        }
        if (this._svgGs.size() == 0) {
            this._svg.getDocumentElement().appendChild(g);
        } else {
            this.getDefs().appendChild(g);
        }
        this._svgGs.add(g);
    }

    public void endGroup() {
        Element g = this._svgGs.pop();
        if (g.getChildNodes().getLength() == 0) {
            g.getParentNode().removeChild(g);
        }
    }

    public final Element createSubGroup(Matrix transform, String id) {
        Element group = this.createSubGroup(id, "g");
        if (transform != null) {
            group.setAttribute("transform", transform.getSvgTransformationString(20.0, 1.0));
        }
        return group;
    }

    public final Element createClipPath(Matrix transform, String id) {
        Element group = this.createSubGroup(id, "clipPath");
        Node parent = group.getParentNode();
        if (parent instanceof Element) {
            Element parentElement = (Element)parent;
            group.setAttribute("transform", parentElement.getAttribute("transform"));
        }
        return group;
    }

    private Element createSubGroup(String id, String tagName) {
        Element group = this._svg.createElement(tagName);
        if (id != null) {
            group.setAttribute("id", id);
        }
        this._svgGs.peek().appendChild(group);
        this._svgGs.add(group);
        return group;
    }

    public void addToGroup(Node newChild) {
        this._svgGs.peek().appendChild(newChild);
    }

    public void addToDefs(Node newChild) {
        this.getDefs().appendChild(newChild);
    }

    public Element createElement(String tagName) {
        return this._svg.createElement(tagName);
    }

    public String getSVG() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(this._svg);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            Logger.getLogger(SVGExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return writer.toString();
    }

    public void setBackGroundColor(Color backGroundColor) {
        Attr attr = this._svg.createAttribute("style");
        attr.setValue("background: " + new RGBA(backGroundColor).toHexARGB());
    }

    public Element addUse(Matrix transform, RECT boundRect, String href, String instanceName) {
        Element image = this._svg.createElement("use");
        if (transform != null) {
            image.setAttribute("transform", transform.getSvgTransformationString(20.0, 1.0));
            image.setAttribute("width", Double.toString((double)boundRect.getWidth() / 20.0));
            image.setAttribute("height", Double.toString((double)boundRect.getHeight() / 20.0));
        }
        if (instanceName != null) {
            image.setAttribute("id", instanceName);
        }
        image.setAttribute("xlink:href", "#" + href);
        this._svgGs.peek().appendChild(image);
        return image;
    }

    public void addStyle(String fontFace, byte[] data, FontExportMode mode) {
        if (!this.fontFaces.contains(fontFace)) {
            this.fontFaces.add(fontFace);
            String base64Data = Helper.byteArrayToBase64String(data);
            String value = this.getStyle().getTextContent();
            value = value + Helper.newLine;
            value = value + "      @font-face {" + Helper.newLine;
            value = value + "        font-family: \"" + fontFace + "\";" + Helper.newLine;
            switch (mode) {
                case TTF: {
                    value = value + "        src: url('data:font/truetype;base64," + base64Data + "') format(\"truetype\");" + Helper.newLine;
                    break;
                }
                case WOFF: {
                    value = value + "        src: url('data:font/woff;base64," + base64Data + "') format(\"woff\");" + Helper.newLine;
                }
            }
            value = value + "      }" + Helper.newLine;
            this.getStyle().setTextContent(value);
        }
    }

    public String getUniqueId(String prefix) {
        Integer lastId = this.lastIds.get(prefix);
        if (lastId == null) {
            lastId = 0;
        } else {
            Integer n = lastId;
            Integer n2 = lastId = Integer.valueOf(lastId + 1);
        }
        this.lastIds.put(prefix, lastId);
        return prefix + lastId;
    }

    protected static double roundPixels20(double pixels) {
        return (double)Math.round(pixels * 100.0) / 100.0;
    }
}

