/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.amf.amf3;

import com.jpexs.decompiler.flash.amf.amf3.ListSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ListMap<K, V>
implements Map<K, V> {
    private final Set<K> orderedKeys = new ListSet<K>();
    private final Map<K, V> map;

    public ListMap() {
        this(false);
    }

    public ListMap(boolean useIdentityMap) {
        this(useIdentityMap, new HashMap());
    }

    public ListMap(Map<? extends K, ? extends V> m) {
        this(false, m);
    }

    public ListMap(boolean useIdentityMap, Map<? extends K, ? extends V> m) {
        this.map = useIdentityMap ? new IdentityHashMap() : new HashMap();
        this.putAll(m);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.orderedKeys.add(key);
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.orderedKeys.remove(key);
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.orderedKeys.add(e.getKey());
        }
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.orderedKeys.clear();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return new ListSet<K>(this.orderedKeys);
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> vals = new ArrayList<V>();
        for (K key : this.orderedKeys) {
            vals.add(this.map.get(key));
        }
        return vals;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ListSet<Map.Entry<K, V>> ret = new ListSet<Map.Entry<K, V>>();
        for (K key : this.orderedKeys) {
            V value = this.map.get(key);
            ret.add(new MyEntry<K, V>(key, value));
        }
        return ret;
    }

    public static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public MyEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + Objects.hashCode(this.key);
            hash = 37 * hash + Objects.hashCode(this.value);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyEntry other = (MyEntry)obj;
            if (!Objects.equals(this.key, other.key)) {
                return false;
            }
            return Objects.equals(this.value, other.value);
        }
    }
}

