/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.amf.amf3;

import com.jpexs.decompiler.flash.amf.amf3.types.Amf3ValueType;
import com.jpexs.decompiler.flash.amf.amf3.types.BasicType;
import com.jpexs.decompiler.flash.exporters.amf.amf3.Amf3Exporter;
import com.jpexs.decompiler.flash.importers.amf.amf3.Amf3Importer;
import com.jpexs.decompiler.flash.importers.amf.amf3.Amf3ParseException;
import com.jpexs.decompiler.flash.types.annotations.Multiline;
import com.jpexs.decompiler.flash.types.annotations.SWFField;
import java.io.IOException;

public class Amf3Value {
    @SWFField
    @Multiline
    private String data = null;

    public Amf3Value() {
        this.setValue(null);
    }

    public Amf3Value(Object value) {
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (!Amf3Value.isValueValid(value)) {
            throw new IllegalArgumentException("Invalid Amf value: " + value.getClass().getSimpleName());
        }
        this.data = value == null ? "" : Amf3Exporter.amfToString(value, "  ", "\n");
    }

    public static boolean isValueValid(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        return value instanceof Amf3ValueType;
    }

    public Object getValue() {
        Amf3Importer imp = new Amf3Importer();
        try {
            return imp.stringToAmf(this.data);
        }
        catch (Amf3ParseException | IOException ex) {
            return BasicType.UNKNOWN;
        }
    }

    public String toString() {
        return this.data;
    }
}

