/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionStartDrag;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;

public class StartDragActionItem
extends ActionItem {
    public GraphTargetItem target;
    public GraphTargetItem lockCenter;
    public GraphTargetItem constrain;
    public GraphTargetItem y2;
    public GraphTargetItem x2;
    public GraphTargetItem y1;
    public GraphTargetItem x1;

    public StartDragActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem target, GraphTargetItem lockCenter, GraphTargetItem constrain, GraphTargetItem x1, GraphTargetItem y1, GraphTargetItem x2, GraphTargetItem y2) {
        super(instruction, lineStartIns, 0);
        this.target = target;
        this.lockCenter = lockCenter;
        this.constrain = constrain;
        this.y2 = y2;
        this.x2 = x2;
        this.y1 = y1;
        this.x1 = x1;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean hasConstrains = true;
        if (this.constrain instanceof DirectValueActionItem && Double.compare(this.constrain.getResultAsNumber(), 0.0) == 0) {
            hasConstrains = false;
        }
        writer.append("startDrag");
        writer.spaceBeforeCallParenthesies(2);
        writer.append("(");
        this.target.toString(writer, localData);
        writer.append(",");
        this.lockCenter.toString(writer, localData);
        if (hasConstrains) {
            writer.append(",");
            this.x1.toString(writer, localData);
            writer.append(",");
            this.y1.toString(writer, localData);
            writer.append(",");
            this.x2.toString(writer, localData);
            writer.append(",");
            this.y2.toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.target.getNeededSources());
        ret.addAll(this.constrain.getNeededSources());
        ret.addAll(this.x1.getNeededSources());
        ret.addAll(this.x2.getNeededSources());
        ret.addAll(this.y1.getNeededSources());
        ret.addAll(this.y2.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        boolean hasConstrains = true;
        if (this.constrain instanceof DirectValueActionItem && Double.compare(this.constrain.getResultAsNumber(), 0.0) == 0) {
            hasConstrains = false;
        }
        if (hasConstrains) {
            return StartDragActionItem.toSourceMerge(localData, generator, this.x1, this.y1, this.x2, this.y2, this.constrain, this.lockCenter, this.target, new ActionStartDrag());
        }
        return StartDragActionItem.toSourceMerge(localData, generator, this.constrain, this.lockCenter, this.target, new ActionStartDrag());
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

