/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionNewObject;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class NewObjectActionItem
extends ActionItem {
    public GraphTargetItem objectName;
    public List<GraphTargetItem> arguments;

    @Override
    public List<GraphTargetItem> getAllSubItems() {
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        ret.add(this.objectName);
        ret.addAll(this.arguments);
        return ret;
    }

    public NewObjectActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem objectName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.objectName = objectName;
        this.arguments = arguments;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("new ");
        this.stripQuotes(this.objectName, localData, writer);
        writer.spaceBeforeCallParenthesies(this.arguments.size());
        writer.append("(");
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0) {
                writer.append(",");
            }
            this.arguments.get(t).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.objectName.getNeededSources());
        for (GraphTargetItem ti : this.arguments) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return NewObjectActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), this.objectName, new ActionNewObject());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

