/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionNewMethod;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class NewMethodActionItem
extends ActionItem {
    public GraphTargetItem methodName;
    public GraphTargetItem scriptObject;
    public List<GraphTargetItem> arguments;

    @Override
    public List<GraphTargetItem> getAllSubItems() {
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        ret.add(this.scriptObject);
        ret.addAll(this.arguments);
        return ret;
    }

    public NewMethodActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem scriptObject, GraphTargetItem methodName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.methodName = methodName;
        this.arguments = arguments;
        this.scriptObject = scriptObject;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean blankMethod = false;
        if (this.methodName instanceof DirectValueActionItem) {
            if (((DirectValueActionItem)this.methodName).value == Undefined.INSTANCE) {
                blankMethod = true;
            } else if (((DirectValueActionItem)this.methodName).value instanceof String && ((DirectValueActionItem)this.methodName).value.equals("")) {
                blankMethod = true;
            }
        }
        if (!blankMethod) {
            writer.append("new ");
        }
        this.scriptObject.toString(writer, localData);
        if (!blankMethod) {
            writer.append(".");
            if (this.methodName instanceof DirectValueActionItem) {
                if (((DirectValueActionItem)this.methodName).value != Undefined.INSTANCE) {
                    if (((DirectValueActionItem)this.methodName).value instanceof String) {
                        ((DirectValueActionItem)this.methodName).toStringNoQuotes(writer, localData);
                    } else {
                        this.methodName.toString(writer, localData);
                    }
                }
            } else {
                this.methodName.toString(writer, localData);
            }
        }
        writer.spaceBeforeCallParenthesies(this.arguments.size());
        writer.append("(");
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0) {
                writer.append(",");
            }
            this.arguments.get(t).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.methodName.getNeededSources());
        ret.addAll(this.scriptObject.getNeededSources());
        for (GraphTargetItem ti : this.arguments) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return NewMethodActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), this.scriptObject, this.methodName, new ActionNewMethod());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

