/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.fastactionlist;

import com.jpexs.decompiler.flash.action.Action;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ActionItem {
    public Action action;
    public ActionItem prev;
    public ActionItem next;
    private ActionItem jumpTarget;
    public Set<ActionItem> jumpsHere;
    public Set<ActionItem> lastActionOf;
    private List<ActionItem> containerLastActions;
    int reachable;
    public boolean excluded;

    public ActionItem(Action action) {
        this.action = action;
    }

    public boolean isJumpTarget() {
        return this.jumpsHere != null && !this.jumpsHere.isEmpty();
    }

    public int jumpsHereSize() {
        return this.jumpsHere == null ? 0 : this.jumpsHere.size();
    }

    public boolean isContainerLastAction() {
        return this.lastActionOf != null && !this.lastActionOf.isEmpty();
    }

    public void removeJumpTarget() {
        if (this.jumpTarget == null) {
            return;
        }
        if (this.jumpTarget.jumpsHere != null) {
            this.jumpTarget.jumpsHere.remove(this);
        }
        this.jumpTarget = null;
    }

    public ActionItem getJumpTarget() {
        return this.jumpTarget;
    }

    public Action getJumpTargetAction() {
        return this.jumpTarget == null ? null : this.jumpTarget.action;
    }

    public void setJumpTarget(ActionItem item) {
        this.removeJumpTarget();
        if (item == null) {
            return;
        }
        if (item.jumpsHere == null) {
            item.jumpsHere = new HashSet<ActionItem>();
        }
        item.jumpsHere.add(this);
        this.jumpTarget = item;
    }

    public List<ActionItem> getContainerLastActions() {
        return this.containerLastActions;
    }

    public void removeContainerLastActions() {
        if (this.containerLastActions == null) {
            return;
        }
        for (ActionItem lastAction : this.containerLastActions) {
            if (lastAction.lastActionOf == null) continue;
            lastAction.lastActionOf.remove(this);
        }
        this.containerLastActions = null;
    }

    public void replaceContainerLastAction(ActionItem oldItem, ActionItem newItem) {
        if (this.containerLastActions == null) {
            return;
        }
        for (int i = 0; i < this.containerLastActions.size(); ++i) {
            if (this.containerLastActions.get(i) != oldItem) continue;
            this.containerLastActions.set(i, newItem);
            if (oldItem.lastActionOf != null) {
                oldItem.lastActionOf.remove(this);
            }
            newItem.ensureLastActionOf().add(this);
        }
    }

    public void setContainerLastActions(List<ActionItem> lastActions) {
        this.removeContainerLastActions();
        for (ActionItem lastAction : lastActions) {
            lastAction.ensureLastActionOf().add(this);
        }
        this.containerLastActions = lastActions;
    }

    private Set<ActionItem> ensureLastActionOf() {
        if (this.lastActionOf == null) {
            this.lastActionOf = new HashSet<ActionItem>();
        }
        return this.lastActionOf;
    }

    public boolean isExcluded() {
        return this.excluded;
    }
}

