/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.ecma.Undefined;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionScriptObject
implements Cloneable {
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();
    protected Map<String, Object> members = new HashMap<String, Object>();
    protected Object extendsObj;
    protected List<Object> implementsObjs = new ArrayList<Object>();

    public void clearMembers() {
        for (Object o : this.members.values()) {
            if (!(o instanceof ActionScriptObject)) continue;
            ((ActionScriptObject)o).clear();
        }
        this.members.clear();
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public void clear() {
        this.clearMembers();
        this.clearProperties();
    }

    public List<Object> getImplementsObjs() {
        return this.implementsObjs;
    }

    public void setImplementsObjs(List<Object> implementsObjs) {
        this.implementsObjs = implementsObjs;
    }

    public void setExtendsObj(Object extendsObj) {
        this.extendsObj = extendsObj;
    }

    public Object getExtendsObj() {
        return this.extendsObj;
    }

    public void removeMember(String path) {
        String[] pathParts = path.startsWith("/") ? path.substring(1).split("/") : path.split(".");
        ActionScriptObject obj = this;
        for (int i = 0; i < pathParts.length; ++i) {
            String part = pathParts[i];
            Object member = obj.getMember(part);
            if (i == pathParts.length - 1) {
                obj.members.remove(part);
                continue;
            }
            if (!(member instanceof ActionScriptObject)) break;
            obj = (ActionScriptObject)member;
        }
    }

    public List<String> enumerate() {
        return new ArrayList<String>(this.members.keySet());
    }

    public void setProperty(int index, Object value) {
        this.properties.put(index, value);
    }

    public Object getProperty(int index) {
        if (!this.properties.containsKey(index)) {
            return Undefined.INSTANCE;
        }
        return this.properties.get(index);
    }

    public void setMember(String path, Object value) {
        String[] pathParts = path.startsWith("/") ? path.substring(1).split("/") : path.split(".");
        ActionScriptObject obj = this;
        for (int i = 0; i < pathParts.length; ++i) {
            String part = pathParts[i];
            Object member = obj.getMember(part);
            if (i == pathParts.length - 1) {
                obj.members.put(part, value);
                continue;
            }
            if (!(member instanceof ActionScriptObject)) break;
            obj = (ActionScriptObject)member;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getMemberPath(Object obj) {
        if (obj == this) {
            return "";
        }
        for (String memberName : this.members.keySet()) {
            String ret;
            Object member = this.members.get(memberName);
            if (member == obj) {
                return memberName;
            }
            if (!(member instanceof ActionScriptObject) || (ret = ((ActionScriptObject)member).getMemberPath(obj)) == null) continue;
            return memberName + "." + ret;
        }
        return null;
    }

    protected Object getThisMember(String name) {
        return this.members.get(name);
    }

    public Object getMember(String path) {
        String[] pathParts = path.startsWith("/") ? path.substring(1).split("/") : path.split(".");
        ActionScriptObject obj = this;
        for (int i = 0; i < pathParts.length; ++i) {
            String part = pathParts[i];
            if (i == pathParts.length - 1) {
                return obj.getThisMember(part);
            }
            Object member = obj.getMember(part);
            if (!(member instanceof ActionScriptObject)) break;
            obj = (ActionScriptObject)member;
        }
        return null;
    }
}

