/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionGraphSource
extends GraphSource {
    private final List<Action> actions;
    public int version;
    private final HashMap<Integer, String> registerNames;
    private final HashMap<String, GraphTargetItem> variables;
    private final HashMap<String, GraphTargetItem> functions;
    private List<Long> posCache = null;

    public List<Action> getActions() {
        return this.actions;
    }

    public ActionGraphSource(List<Action> actions, int version, HashMap<Integer, String> registerNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions) {
        this.actions = actions;
        this.version = version;
        this.registerNames = registerNames;
        this.variables = variables;
        this.functions = functions;
    }

    @Override
    public int size() {
        return this.actions.size();
    }

    @Override
    public GraphSourceItem get(int pos) {
        return this.actions.get(pos);
    }

    public void set(int pos, Action t) {
        this.actions.set(pos, t);
    }

    @Override
    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    @Override
    public List<GraphTargetItem> translatePart(GraphPart part, BaseLocalData localData, TranslateStack stack, int start, int end, int staticOperation, String path) throws InterruptedException {
        Reference<GraphSourceItem> fi = new Reference<GraphSourceItem>(localData.lineStartInstruction);
        List<GraphTargetItem> r = Action.actionsPartToTree(fi, this.registerNames, this.variables, this.functions, stack, this.actions, start, end, this.version, staticOperation, path);
        localData.lineStartInstruction = fi.getVal();
        return r;
    }

    private void rebuildCache() {
        this.posCache = new ArrayList<Long>();
        for (int i = 0; i < this.size(); ++i) {
            this.posCache.add(this.pos2adr(i));
        }
    }

    @Override
    public int adr2pos(long adr) {
        if (this.posCache == null) {
            this.rebuildCache();
        }
        if (adr == 0L) {
            return 0;
        }
        int ret = this.posCache.indexOf(adr);
        if (ret == -1) {
            if (!this.posCache.isEmpty() && adr > this.posCache.get(this.posCache.size() - 1)) {
                return this.size();
            }
            if (ret == -1) {
                Logger.getLogger(ActionGraphSource.class.getName()).log(Level.SEVERE, "Address loc" + Helper.formatAddress(adr) + " not found");
            }
        }
        return ret;
    }

    @Override
    public long pos2adr(int pos) {
        GraphSourceItem si = this.actions.get(pos);
        if (si instanceof Action) {
            return ((Action)si).getAddress();
        }
        return 0L;
    }
}

