/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.UnboundedTypeItem;
import java.util.List;

public class ModuloAVM2Item
extends BinaryOpItem {
    public ModuloAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(instruction, lineStartIns, 3, leftSide, rightSide, "%", "Number", "Number");
    }

    @Override
    public Object getResult() {
        Double rightResult = this.rightSide.getResultAsNumber();
        if (Double.isNaN(rightResult) || Double.compare(rightResult, 0.0) == 0) {
            return Double.NaN;
        }
        return (long)this.leftSide.getResultAsNumber().doubleValue() % (long)rightResult.doubleValue();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.rightSide.getPrecedence() >= this.precedence) {
            if (this.leftSide.getPrecedence() > this.precedence) {
                writer.append("(");
                this.leftSide.toString(writer, localData);
                writer.append(")");
            } else {
                this.leftSide.toString(writer, localData);
            }
            writer.append(" ");
            writer.append(this.operator);
            writer.append(" ");
            writer.append("(");
            this.rightSide.toString(writer, localData);
            return writer.append(")");
        }
        return super.appendTo(writer, localData);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return ModuloAVM2Item.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new AVM2Instruction(0L, 164, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return new UnboundedTypeItem();
    }
}

