/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.List;
import java.util.Set;

public class StringAVM2Item
extends AVM2Item
implements SimpleValue {
    private String value;
    private Double numberValue;

    public StringAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, String value) {
        super(instruction, lineStartIns, 0);
        this.value = value;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        return writer.append("\"").append(Helper.escapeActionScriptString(this.value)).append("\"");
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return true;
    }

    @Override
    public Object getResult() {
        return this.value;
    }

    @Override
    public Double getResultAsNumber() {
        if (this.numberValue == null) {
            this.numberValue = super.getResultAsNumber();
        }
        return this.numberValue;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return StringAVM2Item.toSourceMerge(localData, generator, new AVM2Instruction(0L, 44, new int[]{((AVM2SourceGenerator)generator).str(this.value)}));
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.STRING;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public boolean isSimpleValue() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.numberValue = null;
    }
}

