/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.ecma.ArrayType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class NewArrayAVM2Item
extends AVM2Item {
    public List<GraphTargetItem> values;

    public NewArrayAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, List<GraphTargetItem> values) {
        super(instruction, lineStartIns, 0);
        this.values = values;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("[");
        for (int a = 0; a < this.values.size(); ++a) {
            if (a > 0) {
                writer.append(",");
            }
            this.values.get(a).toString(writer, localData);
        }
        return writer.append("]");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.ARRAY;
    }

    @Override
    public Object getResult() {
        ArrayList<Object> ovalues = new ArrayList<Object>();
        for (GraphTargetItem it : this.values) {
            Object o = it.getResult();
            if (o == null) {
                return null;
            }
            ovalues.add(o);
        }
        return new ArrayType(ovalues);
    }

    @Override
    public GraphTargetItem simplify(String implicitCoerce) {
        if (implicitCoerce.isEmpty()) {
            return this;
        }
        return super.simplify(implicitCoerce);
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        for (GraphTargetItem v : this.values) {
            if (v.isCompileTime()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return NewArrayAVM2Item.toSourceMerge(localData, generator, this.values, new AVM2Instruction(0L, 86, new int[]{this.values.size()}));
    }
}

