/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FullMultinameAVM2Item
extends AVM2Item {
    public int multinameIndex;
    public GraphTargetItem name;
    public GraphTargetItem namespace;
    public boolean property;
    public String resolvedMultinameName;

    public FullMultinameAVM2Item(boolean property, GraphSourceItem instruction, GraphSourceItem lineStartIns, int multinameIndex, String resolvedMultinameName, GraphTargetItem name) {
        super(instruction, lineStartIns, 0);
        this.multinameIndex = multinameIndex;
        this.name = name;
        this.namespace = null;
        this.property = property;
        this.resolvedMultinameName = resolvedMultinameName;
    }

    public FullMultinameAVM2Item(boolean property, GraphSourceItem instruction, GraphSourceItem lineStartIns, int multinameIndex, String resolvedMultinameName) {
        super(instruction, lineStartIns, 0);
        this.multinameIndex = multinameIndex;
        this.resolvedMultinameName = resolvedMultinameName;
        this.name = null;
        this.namespace = null;
        this.property = property;
    }

    public FullMultinameAVM2Item(boolean property, GraphSourceItem instruction, GraphSourceItem lineStartIns, int multinameIndex, String resolvedMultinameName, GraphTargetItem name, GraphTargetItem namespace) {
        super(instruction, lineStartIns, 0);
        this.multinameIndex = multinameIndex;
        this.name = name;
        this.namespace = namespace;
        this.property = property;
        this.resolvedMultinameName = resolvedMultinameName;
    }

    public boolean isRuntime() {
        return this.name != null || this.namespace != null;
    }

    public boolean isTopLevel(String tname, AVM2ConstantPool constants, HashMap<Integer, String> localRegNames, List<DottedChain> fullyQualifiedNames) throws InterruptedException {
        String cname = this.name != null ? this.name.toString(LocalData.create(constants, localRegNames, fullyQualifiedNames)) : constants.getMultiname(this.multinameIndex).getName(constants, fullyQualifiedNames, true, true);
        String cns = "";
        if (this.namespace != null) {
            cns = this.namespace.toString(LocalData.create(constants, localRegNames, fullyQualifiedNames));
        } else {
            Namespace ns = constants.getMultiname(this.multinameIndex).getNamespace(constants);
            if (ns != null && ns.name_index != 0) {
                cns = ns.getName(constants).toPrintableString(true);
            }
        }
        return cname.equals(tname) && cns.isEmpty();
    }

    public boolean isXML(AVM2ConstantPool constants, HashMap<Integer, String> localRegNames, List<DottedChain> fullyQualifiedNames) throws InterruptedException {
        return this.isTopLevel("XML", constants, localRegNames, fullyQualifiedNames);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.namespace != null) {
            this.namespace.toString(writer, localData);
            writer.append("::");
        }
        if (this.name != null) {
            writer.append("[");
            if (this.name instanceof IntegerValueAVM2Item) {
                this.name.toString(writer, localData);
            } else {
                this.name.toStringString(writer, localData);
            }
            writer.append("]");
        } else {
            ArrayList<DottedChain> fullyQualifiedNames;
            AVM2ConstantPool constants = localData.constantsAvm2;
            List<Object> list = fullyQualifiedNames = this.property ? new ArrayList() : localData.fullyQualifiedNames;
            if (this.multinameIndex > 0 && this.multinameIndex < constants.getMultinameCount()) {
                writer.append(constants.getMultiname(this.multinameIndex).getName(constants, fullyQualifiedNames, false, true));
            } else {
                writer.append("\u00a7\u00a7multiname(").append(this.multinameIndex).append(")");
            }
        }
        return writer;
    }

    public boolean compareSame(FullMultinameAVM2Item other) {
        if (this.multinameIndex != other.multinameIndex) {
            return false;
        }
        GraphTargetItem tiName = this.name;
        if (this.name != null) {
            this.name = this.name.getThroughDuplicate();
        }
        while (tiName instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)tiName).computedValue != null) {
            tiName = ((LocalRegAVM2Item)tiName).computedValue.getThroughNotCompilable().getThroughDuplicate();
        }
        GraphTargetItem tiName2 = other.name;
        if (tiName2 != null) {
            tiName2 = tiName2.getThroughDuplicate();
        }
        while (tiName2 instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)tiName2).computedValue != null) {
            tiName2 = ((LocalRegAVM2Item)tiName2).computedValue.getThroughNotCompilable().getThroughDuplicate();
        }
        if (tiName != tiName2) {
            return false;
        }
        GraphTargetItem tiNameSpace = this.namespace;
        if (tiNameSpace != null) {
            tiNameSpace = tiNameSpace.getThroughDuplicate();
        }
        while (tiNameSpace instanceof LocalRegAVM2Item) {
            if (((LocalRegAVM2Item)tiNameSpace).computedValue == null) continue;
            tiNameSpace = ((LocalRegAVM2Item)tiNameSpace).computedValue.getThroughNotCompilable().getThroughDuplicate();
        }
        GraphTargetItem tiNameSpace2 = other.namespace;
        if (tiNameSpace2 != null) {
            tiNameSpace2 = tiNameSpace2.getThroughDuplicate();
        }
        while (tiNameSpace2 instanceof LocalRegAVM2Item) {
            if (((LocalRegAVM2Item)tiNameSpace2).computedValue == null) continue;
            tiNameSpace2 = ((LocalRegAVM2Item)tiNameSpace2).computedValue.getThroughNotCompilable().getThroughDuplicate();
        }
        return tiNameSpace == tiNameSpace2;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

