/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;

public class AlchemyLoadAVM2Item
extends AVM2Item {
    private final String type;
    private final int size;
    private final GraphTargetItem ofs;

    public AlchemyLoadAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem ofs, String type, int size) {
        super(instruction, lineStartIns, 0);
        this.ofs = ofs;
        this.type = type;
        this.size = size;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("l").append(this.type).append(this.size).append("(");
        this.ofs.toString(writer, localData);
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        String ts = "" + this.type + this.size;
        if (this.type.equals("f4")) {
            ts = "f32x4";
        }
        int code = 0;
        switch (ts) {
            case "i8": {
                code = 53;
                break;
            }
            case "i16": {
                code = 54;
                break;
            }
            case "i32": {
                code = 55;
                break;
            }
            case "f": {
                code = 56;
                break;
            }
            case "f32": {
                code = 57;
                break;
            }
            case "f32x4": {
                code = 10;
            }
        }
        return AlchemyLoadAVM2Item.toSourceMerge(localData, generator, this.ofs, AlchemyLoadAVM2Item.ins(code, new Integer[0]));
    }

    @Override
    public GraphTargetItem returnType() {
        switch (this.type) {
            case "i": {
                return new TypeItem(DottedChain.INT);
            }
            case "f": {
                return new TypeItem(DottedChain.NUMBER);
            }
            case "f4": {
                return new TypeItem("float4");
            }
        }
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

