/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.other;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.SetTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ClassAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.DecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ScriptAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.TraitWithSlot;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class SetSlotIns
extends InstructionDefinition
implements SetTypeIns {
    public SetSlotIns() {
        super(109, "setslot", new int[]{265}, true, new AVM2InstructionFlag[0]);
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        GraphTargetItem inside;
        GraphTargetItem obj;
        int slotIndex = ins.operands[0];
        GraphTargetItem value = stack.pop();
        GraphTargetItem objnoreg = obj = stack.pop();
        obj = obj.getThroughRegister();
        Multiname slotname = null;
        if (obj instanceof NewActivationAVM2Item) {
            ((NewActivationAVM2Item)obj).slots.put(slotIndex, value);
        }
        if (obj instanceof ExceptionAVM2Item) {
            slotname = localData.getConstants().getMultiname(((ExceptionAVM2Item)obj).exception.name_index);
        } else if (obj instanceof ClassAVM2Item) {
            slotname = ((ClassAVM2Item)obj).className;
        } else if (obj instanceof ThisAVM2Item) {
            slotname = ((ThisAVM2Item)obj).classMultiname;
        } else if (obj instanceof ScriptAVM2Item) {
            List<Trait> traits = localData.getScriptInfo().get((int)((ScriptAVM2Item)obj).scriptIndex).traits.traits;
            for (int t = 0; t < traits.size(); ++t) {
                Trait tr = traits.get(t);
                if (!(tr instanceof TraitWithSlot) || ((TraitWithSlot)((Object)tr)).getSlotIndex() != slotIndex) continue;
                slotname = tr.getName(localData.abc);
            }
        } else if (obj instanceof NewActivationAVM2Item) {
            MethodBody body = localData.methodBody;
            List<Trait> traits = body.traits.traits;
            for (int t = 0; t < traits.size(); ++t) {
                Trait trait = traits.get(t);
                if (!(trait instanceof TraitWithSlot) || ((TraitWithSlot)((Object)trait)).getSlotIndex() != slotIndex) continue;
                slotname = trait.getName(localData.abc);
            }
        }
        if (slotname != null && value instanceof LocalRegAVM2Item) {
            LocalRegAVM2Item lr = (LocalRegAVM2Item)value;
            String slotNameStr = slotname.getName(localData.getConstants(), localData.fullyQualifiedNames, true, true);
            if (localData.localRegNames.containsKey(lr.regIndex) && localData.localRegNames.get(lr.regIndex).equals(slotNameStr)) {
                return;
            }
        }
        if (value.getNotCoerced().getThroughDuplicate() instanceof IncrementAVM2Item && (inside = ((IncrementAVM2Item)value.getNotCoerced()).value.getThroughRegister().getNotCoerced().getThroughDuplicate()) instanceof GetSlotAVM2Item) {
            GetSlotAVM2Item slotItem = (GetSlotAVM2Item)inside;
            if (slotItem.scope.getThroughRegister() == obj.getThroughRegister() && slotItem.slotName == slotname) {
                if (stack.size() > 0) {
                    GraphTargetItem top = stack.peek().getNotCoerced().getThroughDuplicate();
                    if (top == inside) {
                        stack.pop();
                        stack.push(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else if (top instanceof IncrementAVM2Item && ((IncrementAVM2Item)top).value == inside) {
                        stack.pop();
                        stack.push(new PreIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else {
                        output.add(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    }
                } else {
                    output.add(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                }
                return;
            }
        }
        if (value.getNotCoerced().getThroughDuplicate() instanceof DecrementAVM2Item && (inside = ((DecrementAVM2Item)value.getNotCoerced()).value.getThroughRegister().getNotCoerced().getThroughDuplicate()) instanceof GetSlotAVM2Item) {
            GetSlotAVM2Item slotItem = (GetSlotAVM2Item)inside;
            if (slotItem.scope.getThroughRegister() == obj.getThroughRegister() && slotItem.slotName == slotname) {
                if (stack.size() > 0) {
                    GraphTargetItem top = stack.peek().getNotCoerced().getThroughDuplicate();
                    if (top == inside) {
                        stack.pop();
                        stack.push(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else if (top instanceof DecrementAVM2Item && ((DecrementAVM2Item)top).value == inside) {
                        stack.pop();
                        stack.push(new PreDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else {
                        output.add(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    }
                } else {
                    output.add(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                }
                return;
            }
        }
        output.add(new SetSlotAVM2Item(ins, localData.lineStartInstruction, obj, slotname, value));
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 2;
    }

    @Override
    public String getObject(Stack<AVM2Item> stack, ABC abc, AVM2Instruction ins, List<AVM2Item> output, MethodBody body, HashMap<Integer, String> localRegNames, List<DottedChain> fullyQualifiedNames) {
        int slotIndex = ins.operands[0];
        String slotname = "";
        for (int t = 0; t < body.traits.traits.size(); ++t) {
            if (!(body.traits.traits.get(t) instanceof TraitSlotConst) || ((TraitSlotConst)body.traits.traits.get((int)t)).slot_id != slotIndex) continue;
            slotname = body.traits.traits.get(t).getName(abc).getName(abc.constants, fullyQualifiedNames, true, true);
        }
        return slotname;
    }
}

