/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.other;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.ClassAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ScriptAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitWithSlot;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import java.util.List;

public class GetSlotIns
extends InstructionDefinition {
    public GetSlotIns() {
        super(108, "getslot", new int[]{265}, true, new AVM2InstructionFlag[0]);
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        int slotIndex = ins.operands[0];
        GraphTargetItem obj = stack.pop();
        obj = obj.getThroughRegister();
        Multiname slotname = null;
        if (obj instanceof ExceptionAVM2Item) {
            slotname = localData.getConstants().getMultiname(((ExceptionAVM2Item)obj).exception.name_index);
        } else if (obj instanceof ClassAVM2Item) {
            slotname = ((ClassAVM2Item)obj).className;
        } else if (obj instanceof ThisAVM2Item) {
            slotname = ((ThisAVM2Item)obj).classMultiname;
        } else if (obj instanceof ScriptAVM2Item) {
            List<Trait> traits = localData.getScriptInfo().get((int)((ScriptAVM2Item)obj).scriptIndex).traits.traits;
            for (int t = 0; t < traits.size(); ++t) {
                Trait tr = traits.get(t);
                if (!(tr instanceof TraitWithSlot) || ((TraitWithSlot)((Object)tr)).getSlotIndex() != slotIndex) continue;
                slotname = tr.getName(localData.abc);
            }
        } else if (obj instanceof NewActivationAVM2Item) {
            MethodBody body = localData.methodBody;
            List<Trait> traits = body.traits.traits;
            for (int t = 0; t < traits.size(); ++t) {
                Trait trait = traits.get(t);
                if (!(trait instanceof TraitWithSlot) || ((TraitWithSlot)((Object)trait)).getSlotIndex() != slotIndex) continue;
                slotname = trait.getName(localData.abc);
            }
        }
        stack.push(new GetSlotAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, obj, slotname));
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }

    @Override
    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }
}

