/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2ExecutionException;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2VerifyErrorException;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.DecLocalIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.DecLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.IncLocalIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.IncLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.TranslateStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public abstract class InstructionDefinition
implements Serializable {
    public static final long serialVersionUID = 1L;
    public int[] operands;
    public String instructionName = "";
    public int instructionCode = 0;
    public boolean canThrow;
    public AVM2InstructionFlag[] flags;

    public InstructionDefinition(int instructionCode, String instructionName, int[] operands, boolean canThrow, AVM2InstructionFlag ... flags) {
        this.instructionCode = instructionCode;
        this.instructionName = instructionName;
        this.operands = operands;
        this.canThrow = canThrow;
        this.flags = flags;
    }

    public boolean hasFlag(AVM2InstructionFlag flag) {
        for (AVM2InstructionFlag f : this.flags) {
            if (f != flag) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.instructionName);
        for (int i = 0; i < this.operands.length; ++i) {
            s.append(AVM2Code.operandTypeToString(this.operands[i], true));
        }
        return s.toString();
    }

    public void verify(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) throws AVM2VerifyErrorException {
        for (int i = 0; i < this.operands.length; ++i) {
            int idx;
            int operand = this.operands[i];
            if (operand == 257) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getMultinameCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getMultinameCount()});
            }
            if (operand == 272) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getDoubleCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getDoubleCount()});
            }
            if (operand == 270) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getIntCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getIntCount()});
            }
            if (operand == 271) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getUIntCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getUIntCount()});
            }
            if (!(operand == 260 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getStringCount() : (operand == 279 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getNamespaceCount() : (operand == 277 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getFloatCount() : (operand == 278 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getFloat4Count() : operand == 273 && ((idx = ins.operands[i]) <= 0 || idx >= constants.getDecimalCount())))))) continue;
            throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getStringCount()});
        }
    }

    public boolean isNotCompileTimeSupported() {
        return false;
    }

    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) throws AVM2ExecutionException {
        return false;
    }

    protected void illegalOpCode(LocalDataArea lda, AVM2Instruction ins) throws AVM2VerifyErrorException {
        throw new AVM2VerifyErrorException(1011, lda.isDebug(), new Object[]{lda.methodName, this.instructionCode, ins.getAddress()});
    }

    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) throws InterruptedException {
    }

    public void translate(Reference<GraphSourceItem> lineStartItem, boolean isStatic, int scriptIndex, int classIndex, HashMap<Integer, GraphTargetItem> localRegs, TranslateStack stack, ScopeStack scopeStack, AVM2Instruction ins, List<GraphTargetItem> output, MethodBody body, ABC abc, HashMap<Integer, String> localRegNames, List<DottedChain> fullyQualifiedNames, String path, HashMap<Integer, Integer> localRegsAssignmentIps, int ip, HashMap<Integer, List<Integer>> refs, AVM2Code code, boolean thisHasDefaultToPrimitive) throws InterruptedException {
        AVM2LocalData localData = new AVM2LocalData();
        localData.isStatic = isStatic;
        localData.scriptIndex = scriptIndex;
        localData.classIndex = classIndex;
        localData.lineStartInstruction = lineStartItem.getVal();
        localData.localRegs = localRegs;
        localData.scopeStack = scopeStack;
        localData.methodBody = body;
        localData.abc = abc;
        localData.localRegNames = localRegNames;
        localData.fullyQualifiedNames = fullyQualifiedNames;
        localData.localRegAssignmentIps = localRegsAssignmentIps;
        localData.ip = ip;
        localData.refs = refs;
        localData.code = code;
        localData.thisHasDefaultToPrimitive = thisHasDefaultToPrimitive;
        this.translate(localData, stack, ins, output, path);
        lineStartItem.setVal(localData.lineStartInstruction);
    }

    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 0;
    }

    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 0;
    }

    protected void resolveMultiname(LocalDataArea localData, AVM2ConstantPool constants, int multinameIndex) {
        if (multinameIndex > 0 && multinameIndex < constants.getMultinameCount()) {
            Object object;
            Multiname multiname = constants.getMultiname(multinameIndex);
            if (multiname.needsName()) {
                object = localData.operandStack.pop();
            }
            if (multiname.needsNs()) {
                object = localData.operandStack.pop();
            }
        }
    }

    protected FullMultinameAVM2Item resolveMultiname(AVM2LocalData localData, boolean property, TranslateStack stack, AVM2ConstantPool constants, int multinameIndex, AVM2Instruction ins) {
        GraphTargetItem ns = null;
        GraphTargetItem name = null;
        if (multinameIndex > 0 && multinameIndex < constants.getMultinameCount()) {
            Multiname multiname = constants.getMultiname(multinameIndex);
            if (multiname.needsName()) {
                name = stack.pop();
            }
            if (multiname.needsNs()) {
                ns = stack.pop();
            }
        }
        return new FullMultinameAVM2Item(property, ins, localData.lineStartInstruction, multinameIndex, localData.abc.constants.getMultiname(multinameIndex).getName(localData.getConstants(), new ArrayList<DottedChain>(), true, true), name, ns);
    }

    protected int getMultinameRequiredStackSize(AVM2ConstantPool constants, int multinameIndex) {
        int res = 0;
        if (multinameIndex > 0 && multinameIndex < constants.getMultinameCount()) {
            if (constants.getMultiname(multinameIndex).needsName()) {
                ++res;
            }
            if (constants.getMultiname(multinameIndex).needsNs()) {
                ++res;
            }
        }
        return res;
    }

    protected int resolvedCount(AVM2ConstantPool constants, int multinameIndex) {
        int pos = 0;
        if (constants.getMultiname(multinameIndex).needsNs()) {
            ++pos;
        }
        if (constants.getMultiname(multinameIndex).needsName()) {
            ++pos;
        }
        return pos;
    }

    protected String resolveMultinameNoPop(int pos, Stack<AVM2Item> stack, AVM2ConstantPool constants, int multinameIndex, AVM2Instruction ins, List<DottedChain> fullyQualifiedNames) {
        String ns = "";
        if (constants.getMultiname(multinameIndex).needsNs()) {
            ns = "[" + stack.get(pos) + "]";
            ++pos;
        }
        String name = constants.getMultiname(multinameIndex).needsName() ? ((AVM2Item)stack.get(pos)).toString() : GraphTextWriter.hilighOffset(constants.getMultiname(multinameIndex).getName(constants, fullyQualifiedNames, false, true), ins.getAddress());
        return name + ns;
    }

    public int getStackDelta(AVM2Instruction ins, ABC abc) {
        return this.getStackPushCount(ins, abc) - this.getStackPopCount(ins, abc);
    }

    public int getScopeStackDelta(AVM2Instruction ins, ABC abc) {
        return 0;
    }

    protected boolean isRegisterCompileTime(int regId, int ip, HashMap<Integer, List<Integer>> refs, AVM2Code code) {
        HashSet<Integer> previous = new HashSet<Integer>();
        AVM2Code.getPreviousReachableIps(ip, refs, previous, new HashSet<Integer>());
        Iterator iterator = previous.iterator();
        while (iterator.hasNext()) {
            SetLocalTypeIns sl;
            int p = (Integer)iterator.next();
            if (p < 0 || p >= code.code.size()) continue;
            AVM2Instruction sins = code.code.get(p);
            if (code.code.get((int)p).definition instanceof SetLocalTypeIns && (sl = (SetLocalTypeIns)sins.definition).getRegisterId(sins) == regId && !AVM2Code.isDirectAncestor(ip, p, refs)) {
                return false;
            }
            if (!(code.code.get((int)p).definition instanceof IncLocalIns) && !(code.code.get((int)p).definition instanceof IncLocalIIns) && !(code.code.get((int)p).definition instanceof DecLocalIns) && !(code.code.get((int)p).definition instanceof DecLocalIIns) || sins.operands[0] != regId || AVM2Code.isDirectAncestor(ip, p, refs)) continue;
            return false;
        }
        return true;
    }

    public boolean isExitInstruction() {
        return false;
    }
}

