/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.ConvertOutput;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.TranslateStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AVM2GraphSource
extends GraphSource {
    private final AVM2Code code;
    boolean isStatic;
    int classIndex;
    int scriptIndex;
    HashMap<Integer, GraphTargetItem> localRegs;
    ScopeStack scopeStack;
    ABC abc;
    MethodBody body;
    HashMap<Integer, String> localRegNames;
    List<DottedChain> fullyQualifiedNames;
    HashMap<Integer, Integer> localRegAssigmentIps;
    HashMap<Integer, List<Integer>> refs;

    public AVM2Code getCode() {
        return this.code;
    }

    public AVM2GraphSource(AVM2Code code, boolean isStatic, int scriptIndex, int classIndex, HashMap<Integer, GraphTargetItem> localRegs, ScopeStack scopeStack, ABC abc, MethodBody body, HashMap<Integer, String> localRegNames, List<DottedChain> fullyQualifiedNames, HashMap<Integer, Integer> localRegAssigmentIp, HashMap<Integer, List<Integer>> refs) {
        this.code = code;
        this.isStatic = isStatic;
        this.classIndex = classIndex;
        this.localRegs = localRegs;
        this.scopeStack = scopeStack;
        this.abc = abc;
        this.body = body;
        this.localRegNames = localRegNames;
        this.fullyQualifiedNames = fullyQualifiedNames;
        this.scriptIndex = scriptIndex;
        this.localRegAssigmentIps = localRegAssigmentIp;
        this.refs = refs;
        code.calculateDebugFileLine(abc);
    }

    @Override
    public int size() {
        return this.code.code.size();
    }

    @Override
    public AVM2Instruction get(int pos) {
        return this.code.code.get(pos);
    }

    @Override
    public boolean isEmpty() {
        return this.code.code.isEmpty();
    }

    @Override
    public List<GraphTargetItem> translatePart(GraphPart part, BaseLocalData localData, TranslateStack stack, int start, int end, int staticOperation, String path) throws InterruptedException {
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        ScopeStack newstack = ((AVM2LocalData)localData).scopeStack;
        Reference<GraphSourceItem> lineStartItem = new Reference<GraphSourceItem>(localData.lineStartInstruction);
        ConvertOutput co = this.code.toSourceOutput(((AVM2LocalData)localData).thisHasDefaultToPrimitive, lineStartItem, path, part, false, this.isStatic, this.scriptIndex, this.classIndex, this.localRegs, stack, newstack, this.abc, this.body, start, end, this.localRegNames, this.fullyQualifiedNames, new boolean[this.size()], this.localRegAssigmentIps, this.refs);
        localData.lineStartInstruction = lineStartItem.getVal();
        ret.addAll(co.output);
        return ret;
    }

    @Override
    public int adr2pos(long adr) {
        return this.code.adr2pos(adr);
    }

    @Override
    public long pos2adr(int pos) {
        return this.code.pos2adr(pos);
    }
}

