/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapFormat4;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CMapTableBuilder {
    private static final int MAX_FORMAT4_ENDCODE = 65535;
    private final Font.Builder fontBuilder;
    private final Map<Integer, Integer> mapping;

    public CMapTableBuilder(Font.Builder builder, Map<Integer, Integer> map) {
        this.fontBuilder = builder;
        this.mapping = map;
    }

    private List<CMap4Segment> getFormat4Segments() {
        Map.Entry entry;
        int n;
        ArrayList<CMap4Segment> arrayList = new ArrayList<CMap4Segment>();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>(this.mapping);
        if (!treeMap.containsKey(65535)) {
            treeMap.put(65535, 0);
        }
        CMap4Segment cMap4Segment = null;
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext() && (n = ((Integer)(entry = iterator.next()).getKey()).intValue()) <= 65535) {
            int n2 = (Integer)entry.getValue();
            if (cMap4Segment == null || n != cMap4Segment.getEndCode() + 1) {
                cMap4Segment = new CMap4Segment(n, n);
                arrayList.add(cMap4Segment);
            } else {
                cMap4Segment.setEndCode(n);
            }
            cMap4Segment.getGlyphIds().add(n2);
        }
        return arrayList;
    }

    private void buildCMapFormat4(CMapFormat4.Builder builder, List<CMap4Segment> list) {
        ArrayList<CMapFormat4.Builder.Segment> arrayList = new ArrayList<CMapFormat4.Builder.Segment>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = list.size();
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            CMap4Segment cMap4Segment = list.get(i);
            if (cMap4Segment.isContiguous()) {
                n2 = 0;
            } else {
                n2 = (n - i) * FontData.DataSize.USHORT.size();
                arrayList2.addAll(cMap4Segment.getGlyphIds());
                n += cMap4Segment.getGlyphIds().size();
            }
            arrayList.add(new CMapFormat4.Builder.Segment(cMap4Segment.getStartCode(), cMap4Segment.getEndCode(), cMap4Segment.idDelta(), n2));
        }
        builder.setGlyphIdArray(arrayList2);
        builder.setSegments(arrayList);
    }

    public void build() {
        CMapTable.Builder builder = (CMapTable.Builder)this.fontBuilder.newTableBuilder(Tag.cmap);
        CMapFormat4.Builder builder2 = (CMapFormat4.Builder)builder.newCMapBuilder(CMapTable.CMapId.WINDOWS_BMP, CMap.CMapFormat.Format4);
        this.buildCMapFormat4(builder2, this.getFormat4Segments());
    }

    private class CMap4Segment {
        private final int startCode;
        private int endCode;
        List<Integer> glyphIds;

        CMap4Segment(int n, int n2) {
            this.startCode = n;
            this.endCode = n2;
            this.glyphIds = new ArrayList<Integer>();
        }

        private boolean isContiguous() {
            int n = this.glyphIds.get(0);
            for (int i = 1; i < this.glyphIds.size(); ++i) {
                if (this.glyphIds.get(i) == n + i) continue;
                return false;
            }
            return true;
        }

        int idDelta() {
            return this.isContiguous() ? this.getGlyphIds().get(0) - this.getStartCode() : 0;
        }

        public int getStartCode() {
            return this.startCode;
        }

        public void setEndCode(int n) {
            this.endCode = n;
        }

        public int getEndCode() {
            return this.endCode;
        }

        public List<Integer> getGlyphIds() {
            return this.glyphIds;
        }
    }
}

