/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.woff;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.FontDataTable;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.Deflater;

public class WoffWriter {
    protected boolean woff_compression_faster = false;
    private static final long SIGNATURE = 2001684038L;
    private static final int WOFF_HEADER_SIZE = 9 * FontData.DataSize.ULONG.size() + 4 * FontData.DataSize.USHORT.size();

    public WritableFontData convert(Font font) {
        List<TableDirectoryEntry> list = this.createTableDirectoryEntries(font);
        int n = WOFF_HEADER_SIZE + this.computeTableDirectoryEntriesLength(list) + this.computeTablesLength(list);
        WritableFontData writableFontData = WritableFontData.createWritableFontData(n);
        int n2 = 0;
        n2 += this.writeWoffHeader(writableFontData, n2, list, font.sfntVersion(), n, this.extractMajorVersion(font), this.extractMinorVersion(font));
        n2 += this.writeTableDirectoryEntries(writableFontData, n2, list);
        n2 += this.writeTables(writableFontData, n2, list);
        return writableFontData;
    }

    private int extractMajorVersion(Font font) {
        FontHeaderTable fontHeaderTable = (FontHeaderTable)font.getTable(Tag.head);
        return fontHeaderTable.fontRevision() >> 16 & 0xFFFF;
    }

    private int extractMinorVersion(Font font) {
        FontHeaderTable fontHeaderTable = (FontHeaderTable)font.getTable(Tag.head);
        return fontHeaderTable.fontRevision() & 0xFFFF;
    }

    private int align4(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    private int computeTableDirectoryEntriesLength(List<TableDirectoryEntry> list) {
        return TableDirectoryEntry.ENTRY_SIZE * list.size();
    }

    private int computeTablesLength(List<TableDirectoryEntry> list) {
        int n = 0;
        for (TableDirectoryEntry tableDirectoryEntry : list) {
            n += tableDirectoryEntry.getCompressedTableLength();
            n = this.align4(n);
        }
        return n;
    }

    private int writeWoffHeader(WritableFontData writableFontData, int n, List<TableDirectoryEntry> list, int n2, int n3, int n4, int n5) {
        int n6 = n;
        n6 += writableFontData.writeULong(n6, 2001684038L);
        n6 += writableFontData.writeULong(n6, n2);
        n6 += writableFontData.writeULong(n6, n3);
        n6 += writableFontData.writeUShort(n6, list.size());
        n6 += writableFontData.writeUShort(n6, 0);
        n6 += writableFontData.writeULong(n6, this.computeUncompressedTablesLength(list) + this.computeTableSfntHeaderLength(list));
        n6 += writableFontData.writeUShort(n6, 1);
        n6 += writableFontData.writeUShort(n6, 1);
        n6 += writableFontData.writeULong(n6, 0L);
        n6 += writableFontData.writeULong(n6, 0L);
        n6 += writableFontData.writeULong(n6, 0L);
        n6 += writableFontData.writeULong(n6, 0L);
        n6 += writableFontData.writeULong(n6, 0L);
        return WOFF_HEADER_SIZE;
    }

    private int computeTableSfntHeaderLength(List<TableDirectoryEntry> list) {
        return FontData.DataSize.ULONG.size() + 4 * FontData.DataSize.USHORT.size() + 4 * FontData.DataSize.ULONG.size() * list.size();
    }

    private int computeUncompressedTablesLength(List<TableDirectoryEntry> list) {
        int n = 0;
        for (TableDirectoryEntry tableDirectoryEntry : list) {
            n = (int)((long)n + tableDirectoryEntry.getUncompressedTableLength());
            n = this.align4(n);
        }
        return n;
    }

    private int writeTableDirectoryEntries(WritableFontData writableFontData, int n, List<TableDirectoryEntry> list) {
        int n2 = n;
        int n3 = this.align4(n + this.computeTableDirectoryEntriesLength(list));
        for (TableDirectoryEntry tableDirectoryEntry : list) {
            n2 += tableDirectoryEntry.writeEntry(writableFontData, n3, n2);
            n3 += tableDirectoryEntry.getCompressedTableLength();
            n3 = this.align4(n3);
        }
        return this.computeTableDirectoryEntriesLength(list);
    }

    private int writeTables(WritableFontData writableFontData, int n, List<TableDirectoryEntry> list) {
        int n2 = this.align4(n);
        for (TableDirectoryEntry tableDirectoryEntry : list) {
            n2 += tableDirectoryEntry.writeTable(writableFontData, n2);
            n2 = this.align4(n2);
        }
        return n2 - n;
    }

    private List<TableDirectoryEntry> createTableDirectoryEntries(Font font) {
        ArrayList<TableDirectoryEntry> arrayList = new ArrayList<TableDirectoryEntry>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>(font.tableMap().keySet());
        treeSet.remove(Tag.DSIG);
        for (int n : treeSet) {
            Object t = font.getTable(n);
            TableDirectoryEntry tableDirectoryEntry = new TableDirectoryEntry();
            tableDirectoryEntry.setTag(n);
            tableDirectoryEntry.setOrigLength(((FontDataTable)t).dataLength());
            tableDirectoryEntry.setOrigChecksum(((Table)t).calculatedChecksum());
            this.setCompressedTableData(tableDirectoryEntry, (Table)t);
            arrayList.add(tableDirectoryEntry);
        }
        return arrayList;
    }

    private void setCompressedTableData(TableDirectoryEntry tableDirectoryEntry, Table table) {
        int n = table.dataLength();
        byte[] byArray = new byte[n];
        table.readFontData().readBytes(0, byArray, 0, n);
        if (this.woff_compression_faster && (n < 100 || table.headerTag() == Tag.loca)) {
            tableDirectoryEntry.setCompTable(byArray);
        } else {
            byte[] byArray2 = new byte[n];
            Deflater deflater = new Deflater();
            deflater.setInput(byArray);
            deflater.finish();
            int n2 = deflater.deflate(byArray2);
            tableDirectoryEntry.setCompTable(n2 == n || !deflater.finished() ? byArray : Arrays.copyOfRange(byArray2, 0, n2));
        }
    }

    private static class TableDirectoryEntry {
        public static final int ENTRY_SIZE = 5 * FontData.DataSize.ULONG.size();
        private long tag;
        private long origLength;
        private long origChecksum;
        private byte[] compTable;

        private TableDirectoryEntry() {
        }

        public void setTag(int n) {
            this.tag = n;
        }

        public void setOrigLength(int n) {
            this.origLength = n;
        }

        public void setOrigChecksum(long l) {
            this.origChecksum = l;
        }

        public void setCompTable(byte[] byArray) {
            this.compTable = byArray;
        }

        public int getCompressedTableLength() {
            return this.compTable.length;
        }

        public long getUncompressedTableLength() {
            return this.origLength;
        }

        public int writeEntry(WritableFontData writableFontData, int n, int n2) {
            int n3 = n2;
            n3 += writableFontData.writeULong(n3, this.tag);
            n3 += writableFontData.writeULong(n3, n);
            n3 += writableFontData.writeULong(n3, this.compTable.length);
            n3 += writableFontData.writeULong(n3, this.origLength);
            n3 += writableFontData.writeULong(n3, this.origChecksum);
            return ENTRY_SIZE;
        }

        public int writeTable(WritableFontData writableFontData, int n) {
            writableFontData.writeBytes(n, this.compTable, 0, this.compTable.length);
            return this.getCompressedTableLength();
        }
    }
}

